/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.Normalizer;

public class SubstringNode
extends LeafNode {
    private String initialPattern;
    private String finalPattern;
    private List<String> anyPattern;

    public SubstringNode(AttributeType attributeType, String initialPattern, String finalPattern) {
        super(attributeType, AssertionType.SUBSTRING);
        this.anyPattern = new ArrayList<String>(2);
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public SubstringNode(String attribute, String initialPattern, String finalPattern) {
        super(attribute, AssertionType.SUBSTRING);
        this.anyPattern = new ArrayList<String>(2);
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public SubstringNode(AttributeType attribute) {
        super(attribute, AssertionType.SUBSTRING);
        this.anyPattern = new ArrayList<String>(2);
        this.finalPattern = null;
        this.initialPattern = null;
    }

    public SubstringNode(String attributeType) {
        super(attributeType, AssertionType.SUBSTRING);
        this.anyPattern = new ArrayList<String>(2);
        this.finalPattern = null;
        this.initialPattern = null;
    }

    public SubstringNode(List<String> anyPattern, AttributeType attributeType, String initialPattern, String finalPattern) {
        super(attributeType, AssertionType.SUBSTRING);
        this.anyPattern = anyPattern;
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public SubstringNode(List<String> anyPattern, String attribute, String initialPattern, String finalPattern) {
        super(attribute, AssertionType.SUBSTRING);
        this.anyPattern = anyPattern;
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public static Pattern getRegex(String initialPattern, String[] anyPattern, String finalPattern) {
        StringBuilder buf = new StringBuilder();
        if (initialPattern != null) {
            buf.append('^').append(Pattern.quote(initialPattern));
        }
        if (anyPattern != null) {
            for (int i = 0; i < anyPattern.length; ++i) {
                buf.append(".*").append(Pattern.quote(anyPattern[i]));
            }
        }
        if (finalPattern != null) {
            buf.append(".*").append(Pattern.quote(finalPattern));
        } else {
            buf.append(".*");
        }
        return Pattern.compile(buf.toString());
    }

    @Override
    public ExprNode clone() {
        ExprNode clone = super.clone();
        if (this.anyPattern != null) {
            ((SubstringNode)clone).anyPattern = new ArrayList<String>();
            for (String any : this.anyPattern) {
                ((SubstringNode)clone).anyPattern.add(any);
            }
        }
        return clone;
    }

    public final String getInitial() {
        return this.initialPattern;
    }

    public void setInitial(String initialPattern) {
        this.initialPattern = initialPattern;
    }

    public final String getFinal() {
        return this.finalPattern;
    }

    public void setFinal(String finalPattern) {
        this.finalPattern = finalPattern;
    }

    public final List<String> getAny() {
        return this.anyPattern;
    }

    public void setAny(List<String> anyPattern) {
        this.anyPattern = anyPattern;
    }

    public void addAny(String anyPattern) {
        this.anyPattern.add(anyPattern);
    }

    public final Pattern getRegex(Normalizer normalizer) throws LdapException {
        if (this.anyPattern != null && !this.anyPattern.isEmpty()) {
            String[] any = new String[this.anyPattern.size()];
            for (int i = 0; i < any.length; ++i) {
                any[i] = normalizer.normalize(this.anyPattern.get(i));
                if (any[i].length() != 0) continue;
                any[i] = " ";
            }
            String initialStr = null;
            if (this.initialPattern != null) {
                initialStr = normalizer.normalize(this.initialPattern);
            }
            String finalStr = null;
            if (this.finalPattern != null) {
                finalStr = normalizer.normalize(this.finalPattern);
            }
            return SubstringNode.getRegex(initialStr, any, finalStr);
        }
        String initialStr = null;
        if (this.initialPattern != null) {
            initialStr = normalizer.normalize(this.initialPattern);
        }
        String finalStr = null;
        if (this.finalPattern != null) {
            finalStr = normalizer.normalize(this.finalPattern);
        }
        return SubstringNode.getRegex(initialStr, null, finalStr);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SubstringNode)) {
            return false;
        }
        SubstringNode that = (SubstringNode)obj;
        if (this.initialPattern == null ? that.initialPattern != null : !this.initialPattern.equals(that.initialPattern)) {
            return false;
        }
        if (this.finalPattern == null ? that.finalPattern != null : !this.finalPattern.equals(that.finalPattern)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.initialPattern != null ? this.initialPattern.hashCode() : 0);
        if (this.anyPattern != null) {
            for (String pattern : this.anyPattern) {
                h = h * 17 + pattern.hashCode();
            }
        }
        h = h * 17 + (this.finalPattern != null ? this.finalPattern.hashCode() : 0);
        return h;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (this.attributeType != null) {
            buf.append(this.attributeType.getName());
        } else {
            buf.append(this.attribute);
        }
        buf.append('=');
        if (null != this.initialPattern) {
            buf.append(SubstringNode.escapeFilterValue(new StringValue(this.initialPattern))).append('*');
        } else {
            buf.append('*');
        }
        if (null != this.anyPattern) {
            for (String any : this.anyPattern) {
                buf.append(SubstringNode.escapeFilterValue(new StringValue(any)));
                buf.append('*');
            }
        }
        if (null != this.finalPattern) {
            buf.append(SubstringNode.escapeFilterValue(new StringValue(this.finalPattern)));
        }
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

