/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53domains.model.Nameserver;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateDomainNameserversRequestMarshaller
implements Marshaller<Request<UpdateDomainNameserversRequest>, UpdateDomainNameserversRequest> {
    public Request<UpdateDomainNameserversRequest> marshall(UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        if (updateDomainNameserversRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDomainNameserversRequest, "AmazonRoute53Domains");
        String target = "Route53Domains_v20140515.UpdateDomainNameservers";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag nameserversList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateDomainNameserversRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value((Object)updateDomainNameserversRequest.getDomainName());
            }
            if (!((nameserversList = (ListWithAutoConstructFlag)updateDomainNameserversRequest.getNameservers()) == null || nameserversList.isAutoConstruct() && nameserversList.isEmpty())) {
                jsonWriter.key("Nameservers");
                jsonWriter.array();
                for (Nameserver nameserversListValue : nameserversList) {
                    ListWithAutoConstructFlag glueIpsList;
                    if (nameserversListValue == null) continue;
                    jsonWriter.object();
                    if (nameserversListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)nameserversListValue.getName());
                    }
                    if (!((glueIpsList = (ListWithAutoConstructFlag)nameserversListValue.getGlueIps()) == null || glueIpsList.isAutoConstruct() && glueIpsList.isEmpty())) {
                        jsonWriter.key("GlueIps");
                        jsonWriter.array();
                        for (String glueIpsListValue : glueIpsList) {
                            if (glueIpsListValue == null) continue;
                            jsonWriter.value((Object)glueIpsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

