/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.SecureVaultException;

public class PasswordManager {
    private static final Log log = LogFactory.getLog(PasswordManager.class);
    private static PasswordManager ourInstance = new PasswordManager();
    private SecretResolver secretResolver;
    private boolean initialized = false;

    public static PasswordManager getInstance() {
        return ourInstance;
    }

    private PasswordManager() {
    }

    public void init(Properties properties, String prefix) {
        this.secretResolver = SecretResolverFactory.create(properties, prefix);
        this.initialized = this.secretResolver.isInitialized();
    }

    public String resolve(String encryptedPassword) {
        this.assertInitialized();
        return this.secretResolver.resolve(encryptedPassword);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void addProtectedToken(String token) {
        this.assertInitialized();
        this.secretResolver.addProtectedToken(token);
    }

    public boolean isTokenProtected(String token) {
        this.assertInitialized();
        return this.secretResolver.isTokenProtected(token);
    }

    public void shutDown() {
        this.assertInitialized();
        this.initialized = false;
        this.secretResolver = null;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            this.handleException("PasswordManager has not been initialized");
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SecureVaultException(msg);
    }

    public SecretResolver getSecretResolver() {
        this.assertInitialized();
        return this.secretResolver;
    }
}

