/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AddressingBasedDispatcher;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultitenantAddressingBasedDispatcher
extends AddressingBasedDispatcher {
    public static final String NAME = "MultitenantAddressingBasedDispatcher";
    private static final Log log = LogFactory.getLog(MultitenantAddressingBasedDispatcher.class);

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
        if (msgctx.getRelatesTo() != null) {
            OperationContext operationContext;
            String relatesTo = msgctx.getRelatesTo().getValue();
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(msgctx.getLogIDString() + " " + Messages.getMessage((String)"checkingrelatesto", (String)relatesTo)));
            }
            if (relatesTo != null && !"".equals(relatesTo) && msgctx.getOperationContext() == null && (operationContext = msgctx.getConfigurationContext().getOperationContext(relatesTo)) != null) {
                msgctx.setAxisOperation(operationContext.getAxisOperation());
                msgctx.setAxisMessage(operationContext.getAxisOperation().getMessage("In"));
                msgctx.setOperationContext(operationContext);
                msgctx.setServiceContext((ServiceContext)operationContext.getParent());
                msgctx.setAxisService(((ServiceContext)operationContext.getParent()).getAxisService());
                msgctx.getAxisOperation().registerMessageContext(msgctx, operationContext);
                msgctx.setServiceGroupContextId(((ServiceGroupContext)msgctx.getServiceContext().getParent()).getId());
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)(msgctx.getLogIDString() + " Dispatched successfully on the RelatesTo. operation=" + operationContext.getAxisOperation()));
                }
            }
        } else {
            EndpointReference to = msgctx.getTo();
            if (to == null || to.getAddress().indexOf("/t/") != -1) {
                return Handler.InvocationResponse.CONTINUE;
            }
            response = super.invoke(msgctx);
            Object flag = msgctx.getLocalProperty("IsAddressingProcessed");
            if (log.isTraceEnabled()) {
                log.trace((Object)("invoke: IS_ADDR_INFO_ALREADY_PROCESSED=" + flag));
            }
            if (JavaUtils.isTrueExplicitly((Object)flag) && JavaUtils.isTrue((Object)msgctx.getProperty("addressing.validateAction"), (boolean)true)) {
                this.checkAction(msgctx);
            }
        }
        return response;
    }

    private void checkAction(MessageContext msgContext) throws AxisFault {
        if (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null) {
            AddressingFaultsHelper.triggerActionNotSupportedFault((MessageContext)msgContext, (String)msgContext.getWSAAction());
        }
    }
}

