/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConfigUtil {
    public static final int UNDEFINED_OS = -1;
    public static final int WINDOWS_OS = 0;
    public static final int UNIX_OS = 1;
    public static final int MAC_OS = 2;
    public static final int OTHER_OS = 3;
    private static int osType = -1;
    private static final String PROXY_NAME = "x509up_u";
    private static final String SOLARIS_ID_EXEC = "/usr/xpg4/bin/id";
    public static String globus_dir = null;

    public static String discoverPKCS11LibName() {
        return "dspkcs";
    }

    public static String discoverUserCertLocation() {
        String location = null;
        location = globus_dir + "usercert.pem";
        return location;
    }

    public static String discoverUserKeyLocation() {
        String location = null;
        location = globus_dir + "userkey.pem";
        return location;
    }

    public static String discoverProxyLocation() {
        String suffix;
        String tmpDir;
        String dir = null;
        dir = ConfigUtil.getOS() == 1 ? "/tmp/" : ((tmpDir = System.getProperty("java.io.tmpdir")) == null ? globus_dir : tmpDir);
        String uid = System.getProperty("UID");
        if (uid != null) {
            return ConfigUtil.getLocation(dir, PROXY_NAME + uid);
        }
        if (ConfigUtil.getOS() == 1) {
            try {
                return ConfigUtil.getLocation(dir, PROXY_NAME + ConfigUtil.getUID());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        suffix = (suffix = System.getProperty("user.name")) != null ? suffix.toLowerCase() : "nousername";
        return ConfigUtil.getLocation(dir, "x509up_u_" + suffix);
    }

    private static String getLocation(String dir, String file) {
        File f = new File(dir, file);
        return f.getAbsolutePath();
    }

    public static String getUID() throws IOException {
        String exec = "id";
        String osname = System.getProperty("os.name");
        if (osname != null) {
            if ((osname = osname.toLowerCase()).indexOf("solaris") != -1 || osname.indexOf("sunos") != -1) {
                if (new File(SOLARIS_ID_EXEC).exists()) {
                    exec = SOLARIS_ID_EXEC;
                }
            } else if (osname.indexOf("windows") != -1) {
                throw new IOException("Unable to determine the user id");
            }
        }
        Runtime runTime = Runtime.getRuntime();
        Process process = null;
        BufferedReader buffInReader = null;
        String s = null;
        StringBuffer output = new StringBuffer();
        int exitValue = -1;
        try {
            process = runTime.exec(exec + " -u");
            buffInReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((s = buffInReader.readLine()) != null) {
                output.append(s);
            }
            exitValue = process.waitFor();
        }
        catch (Exception e) {
            throw new IOException("Unable to execute 'id -u'");
        }
        finally {
            if (buffInReader != null) {
                try {
                    buffInReader.close();
                }
                catch (IOException e) {}
            }
            if (process != null) {
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {}
            }
        }
        if (exitValue != 0) {
            throw new IOException("Unable to perform 'id -u'");
        }
        return output.toString().trim();
    }

    public static String discoverCertDirLocation() {
        String location = null;
        location = ConfigUtil.getDir(globus_dir + "certificates");
        if (location != null) {
            return location;
        }
        if (ConfigUtil.getOS() == 1 && (location = ConfigUtil.getDir("/etc/grid-security/certificates")) != null) {
            return location;
        }
        String suffix = File.separator + "share" + File.separator + "certificates";
        location = ConfigUtil.getDir(System.getProperty("GLOBUS_LOCATION") + suffix);
        if (location != null) {
            return location;
        }
        return null;
    }

    public static int getOS() {
        if (osType != -1) {
            return osType;
        }
        String osname = System.getProperty("os.name");
        osType = osname != null ? ((osname = osname.toLowerCase()).indexOf("windows") != -1 ? 0 : (osname.indexOf("solaris") != -1 || osname.indexOf("sunos") != -1 || osname.indexOf("linux") != -1 || osname.indexOf("aix") != -1 || osname.indexOf("hp-ux") != -1 || osname.indexOf("compaq's digital unix") != -1 || osname.indexOf("osf1") != -1 || osname.indexOf("mac os x") != -1 || osname.indexOf("netbsd") != -1 || osname.indexOf("freebsd") != -1 || osname.indexOf("irix") != -1 ? 1 : (osname.indexOf("mac") != -1 ? 2 : 3))) : 3;
        return osType;
    }

    private static String getDir(String directory) {
        if (directory == null) {
            return null;
        }
        File f = new File(directory);
        if (f.isDirectory() && f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    static {
        globus_dir = System.getProperty("user.home") + File.separator + ".globus" + File.separator;
    }
}

