/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import org.globus.common.CoGProperties;

public class PortRange {
    protected static final byte UNUSED = 0;
    protected static final byte USED = 1;
    private boolean portRange = false;
    private int minPort;
    private int maxPort;
    private byte[] ports;
    private static PortRange tcpPortRange = null;
    private static PortRange tcpSourcePortRange = null;
    private static PortRange udpSourcePortRange = null;

    protected PortRange() {
    }

    public static PortRange getInstance() {
        return PortRange.getTcpInstance();
    }

    public static synchronized PortRange getTcpInstance() {
        if (tcpPortRange == null) {
            tcpPortRange = new PortRange();
            tcpPortRange.init(CoGProperties.getDefault().getTcpPortRange());
        }
        return tcpPortRange;
    }

    public static synchronized PortRange getTcpSourceInstance() {
        if (tcpSourcePortRange == null) {
            tcpSourcePortRange = new PortRange();
            tcpSourcePortRange.init(CoGProperties.getDefault().getTcpSourcePortRange());
        }
        return tcpSourcePortRange;
    }

    public static synchronized PortRange getUdpSourceInstance() {
        if (udpSourcePortRange == null) {
            udpSourcePortRange = new PortRange();
            udpSourcePortRange.init(CoGProperties.getDefault().getUdpSourcePortRange());
        }
        return udpSourcePortRange;
    }

    public boolean isEnabled() {
        return this.portRange;
    }

    public synchronized int getFreePort(int lastPortNumber) throws IOException {
        int id = 0;
        if (lastPortNumber != 0 && (id = lastPortNumber - this.minPort) < 0) {
            throw new IOException("Port number out of range.");
        }
        for (int i = id; i < this.ports.length; ++i) {
            if (this.ports[i] == 1) continue;
            return this.minPort + i;
        }
        throw new IOException("No free ports available.");
    }

    public void setUsed(int portNumber) {
        this.setPort(portNumber, (byte)1);
    }

    public void free(int portNumber) {
        this.setPort(portNumber, (byte)0);
    }

    public boolean isInRange(int portNumber) {
        return this.minPort <= portNumber && this.maxPort >= portNumber;
    }

    private synchronized void setPort(int portNumber, byte type) {
        int id = portNumber - this.minPort;
        if (id < 0) {
            throw new IllegalArgumentException("Port number out of range: " + portNumber);
        }
        this.ports[id] = type;
    }

    private void init(String portRangeStr) {
        int max;
        int min;
        this.portRange = false;
        if (portRangeStr == null) {
            return;
        }
        int pos = portRangeStr.indexOf(",");
        if (pos == -1) {
            throw new IllegalArgumentException("Missing comma in the port range property: " + portRangeStr);
        }
        try {
            min = Integer.parseInt(portRangeStr.substring(0, pos).trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The minimum port range value is invalid: " + e.getMessage());
        }
        try {
            max = Integer.parseInt(portRangeStr.substring(pos + 1).trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The maximum port range value is invalid: " + e.getMessage());
        }
        if (min >= max) {
            throw new IllegalArgumentException("The minimum port range value is greater then the maximum port range value.");
        }
        this.minPort = min;
        this.maxPort = max;
        this.ports = new byte[this.maxPort - this.minPort];
        this.portRange = true;
    }
}

