/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.dialect;

import org.apache.lucene.store.jdbc.JdbcDirectorySettings;

public abstract class Dialect {
    public void processSettings(JdbcDirectorySettings settings) {
    }

    public boolean supportTransactionalScopedBlobs() {
        return false;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsTableExists() {
        return false;
    }

    public String sqlTableExists(String catalog, String schemaName) {
        throw new UnsupportedOperationException("Not sql provided to define if a table exists");
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean useExistsBeforeInsertLock() {
        return true;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String openBlobSelectQuote() {
        return "";
    }

    public String closeBlobSelectQuote() {
        return "";
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public abstract boolean supportsForUpdate();

    public String getForUpdateString() {
        return " for update";
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getTableTypeString() {
        return "";
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public abstract String getCurrentTimestampFunction();

    public abstract String getVarcharType(int var1);

    public abstract String getBlobType(long var1);

    public abstract String getNumberType();

    public abstract String getTimestampType();

    public abstract String getBitType();
}

