/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security;

import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.service.security.AiravataSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(SecurityManagerFactory.class);

    public static AiravataSecurityManager getSecurityManager() throws AiravataSecurityException {
        try {
            Class<?> secManagerImpl = Class.forName(ServerSettings.getSecurityManagerClassName());
            AiravataSecurityManager securityManager = (AiravataSecurityManager)secManagerImpl.newInstance();
            return securityManager;
        }
        catch (ClassNotFoundException e) {
            String error = "Security Manager class could not be found.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
        catch (ApplicationSettingsException e) {
            String error = "Error in reading the configuration related to Security Manager class.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
        catch (InstantiationException e) {
            String error = "Error in instantiating the Security Manager class.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
        catch (IllegalAccessException e) {
            String error = "Error in instantiating the Security Manager class.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
    }
}

