/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatform;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import org.apache.brooklyn.camp.spi.pdp.DeploymentPlan;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.objs.BasicSpecParameter;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.entity.stock.BasicApplicationImpl;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.yaml.Yamls;

class CampInternalUtils {
    CampInternalUtils() {
    }

    static EntitySpec<? extends Application> createWrapperApp(AssemblyTemplate template, BrooklynClassLoadingContext loader) {
        BrooklynComponentTemplateResolver resolver = BrooklynComponentTemplateResolver.Factory.newInstance(loader, (AbstractResource)CampInternalUtils.buildWrapperAppTemplate(template));
        EntitySpec wrapperSpec = resolver.resolveSpec((Set<String>)ImmutableSet.of());
        CampInternalUtils.resetSpecIfTemplateHasNoExplicitParameters(template, wrapperSpec);
        return wrapperSpec;
    }

    static void resetSpecIfTemplateHasNoExplicitParameters(AssemblyTemplate template, EntitySpec<? extends Application> wrapperSpec) {
        if (!template.getCustomAttributes().containsKey("brooklyn.parameters")) {
            wrapperSpec.parameters((Iterable)ImmutableList.of());
        }
    }

    private static AssemblyTemplate buildWrapperAppTemplate(AssemblyTemplate template) {
        AssemblyTemplate.Builder builder = AssemblyTemplate.builder();
        builder.type("brooklyn:" + BasicApplicationImpl.class.getName());
        builder.id(template.getId());
        builder.name(template.getName());
        builder.sourceCode(template.getSourceCode());
        for (Map.Entry entry : template.getCustomAttributes().entrySet()) {
            builder.customAttribute((String)entry.getKey(), entry.getValue());
        }
        builder.instantiator(template.getInstantiator());
        AssemblyTemplate wrapTemplate = builder.build();
        return wrapTemplate;
    }

    static AssemblyTemplateInstantiator getInstantiator(AssemblyTemplate at) {
        try {
            return (AssemblyTemplateInstantiator)at.getInstantiator().newInstance();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AssemblyTemplate resolveDeploymentPlan(String plan, BrooklynClassLoadingContext loader, CampPlatform camp) {
        BasicBrooklynCatalog.BrooklynLoaderTracker.setLoader((BrooklynClassLoadingContext)loader);
        try {
            AssemblyTemplate assemblyTemplate = camp.pdp().resolveDeploymentPlan((Reader)new StringReader(plan));
            return assemblyTemplate;
        }
        finally {
            BasicBrooklynCatalog.BrooklynLoaderTracker.unsetLoader((BrooklynClassLoadingContext)loader);
        }
    }

    static PolicySpec<?> createPolicySpec(String yamlPlan, BrooklynClassLoadingContext loader, Set<String> encounteredCatalogTypes) {
        DeploymentPlan plan = CampInternalUtils.makePlanFromYaml(loader.getManagementContext(), yamlPlan);
        Object policies = Preconditions.checkNotNull(plan.getCustomAttributes().get("brooklyn.policies"), (Object)"policy config");
        if (!(policies instanceof Iterable)) {
            throw new IllegalStateException("The value of brooklyn.policies must be an Iterable.");
        }
        Object policy = Iterables.getOnlyElement((Iterable)((Iterable)policies));
        return CampInternalUtils.createPolicySpec(loader, policy, encounteredCatalogTypes);
    }

    static PolicySpec<?> createPolicySpec(BrooklynClassLoadingContext loader, Object policy, Set<String> encounteredCatalogTypes) {
        Object itemMap;
        if (policy instanceof String) {
            itemMap = ImmutableMap.of((Object)"type", (Object)policy);
        } else if (policy instanceof Map) {
            itemMap = (Map)policy;
        } else {
            throw new IllegalStateException("Policy expected to be string or map. Unsupported object type " + policy.getClass().getName() + " (" + policy.toString() + ")");
        }
        String versionedId = (String)Preconditions.checkNotNull((Object)Yamls.getMultinameAttribute((Map)itemMap, (String[])new String[]{"policy_type", "policyType", "type"}), (Object)"policy type");
        PolicySpec<? extends Policy> spec = CampInternalUtils.resolvePolicySpec(versionedId, loader, encounteredCatalogTypes);
        CampInternalUtils.initConfigAndParameters(spec, (Map<String, Object>)itemMap, loader);
        return spec;
    }

    static EnricherSpec<?> createEnricherSpec(String yamlPlan, BrooklynClassLoadingContext loader, Set<String> encounteredCatalogTypes) {
        DeploymentPlan plan = CampInternalUtils.makePlanFromYaml(loader.getManagementContext(), yamlPlan);
        Object enrichers = Preconditions.checkNotNull(plan.getCustomAttributes().get("brooklyn.enrichers"), (Object)"enricher config");
        if (!(enrichers instanceof Iterable)) {
            throw new IllegalStateException("The value of brooklyn.enrichers must be an Iterable.");
        }
        Object policy = Iterables.getOnlyElement((Iterable)((Iterable)enrichers));
        return CampInternalUtils.createEnricherSpec(loader, policy, encounteredCatalogTypes);
    }

    static EnricherSpec<?> createEnricherSpec(BrooklynClassLoadingContext loader, Object enricher, Set<String> encounteredCatalogTypes) {
        Object itemMap;
        if (enricher instanceof String) {
            itemMap = ImmutableMap.of((Object)"type", (Object)enricher);
        } else if (enricher instanceof Map) {
            itemMap = (Map)enricher;
        } else {
            throw new IllegalStateException("Enricher expected to be string or map. Unsupported object type " + enricher.getClass().getName() + " (" + enricher.toString() + ")");
        }
        String versionedId = (String)Preconditions.checkNotNull((Object)Yamls.getMultinameAttribute((Map)itemMap, (String[])new String[]{"enricher_type", "enricherType", "type"}), (Object)"enricher type");
        EnricherSpec<? extends Enricher> spec = CampInternalUtils.resolveEnricherSpec(versionedId, loader, encounteredCatalogTypes);
        CampInternalUtils.initConfigAndParameters(spec, (Map<String, Object>)itemMap, loader);
        return spec;
    }

    static LocationSpec<?> createLocationSpec(String yamlPlan, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        DeploymentPlan plan = CampInternalUtils.makePlanFromYaml(loader.getManagementContext(), yamlPlan);
        Object locations = Preconditions.checkNotNull(plan.getCustomAttributes().get("brooklyn.locations"), (Object)"location config");
        if (!(locations instanceof Iterable)) {
            throw new IllegalStateException("The value of brooklyn.locations must be an Iterable.");
        }
        Object location = Iterables.getOnlyElement((Iterable)((Iterable)locations));
        return CampInternalUtils.createLocationSpec(loader, location);
    }

    private static LocationSpec<?> createLocationSpec(BrooklynClassLoadingContext loader, Object location) {
        Object itemMap;
        if (location instanceof String) {
            itemMap = ImmutableMap.of((Object)"type", (Object)location);
        } else if (location instanceof Map) {
            itemMap = (Map)location;
        } else {
            throw new IllegalStateException("Location expected to be string or map. Unsupported object type " + location.getClass().getName() + " (" + location.toString() + ")");
        }
        String type = (String)Preconditions.checkNotNull((Object)Yamls.getMultinameAttribute((Map)itemMap, (String[])new String[]{"location_type", "locationType", "type"}), (Object)"location type");
        Map brooklynConfig = (Map)itemMap.get("brooklyn.config");
        LocationSpec<?> locationSpec = CampInternalUtils.resolveLocationSpec(type, brooklynConfig, loader);
        CampInternalUtils.initConfigAndParameters(locationSpec, (Map<String, Object>)itemMap, loader);
        return locationSpec;
    }

    protected static void initConfigAndParameters(AbstractBrooklynObjectSpec<?, ?> spec, Map<String, Object> itemMap, BrooklynClassLoadingContext loader) {
        Map brooklynConfig = (Map)itemMap.get("brooklyn.config");
        if (brooklynConfig != null) {
            spec.configure(brooklynConfig);
        }
        List explicitParams = (List)itemMap.get("brooklyn.parameters");
        BasicSpecParameter.initializeSpecWithExplicitParameters(spec, (List)BasicSpecParameter.parseParameterDefinitionList((List)explicitParams, null, (BrooklynClassLoadingContext)loader), (BrooklynClassLoadingContext)loader);
    }

    public static DeploymentPlan makePlanFromYaml(ManagementContext mgmt, String yaml) {
        CampPlatform camp = CampInternalUtils.getCampPlatform(mgmt);
        return camp.pdp().parseDeploymentPlan(Streams.newReaderWithContents((String)yaml));
    }

    @Nonnull
    public static CampPlatform getCampPlatform(ManagementContext mgmt) {
        CampPlatform result = BrooklynCampPlatform.findPlatform(mgmt);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("No CAMP Platform is registered with this Brooklyn management context.");
    }

    private static PolicySpec<? extends Policy> resolvePolicySpec(String versionedId, BrooklynClassLoadingContext loader, Set<String> encounteredCatalogTypes) {
        RegisteredType item = loader.getManagementContext().getTypeRegistry().get(BundleUpgradeParser.CatalogUpgrades.getTypeUpgradedIfNecessary((ManagementContext)loader.getManagementContext(), (String)versionedId));
        if (item != null && !encounteredCatalogTypes.contains(item.getSymbolicName())) {
            RegisteredTypeLoadingContext context = RegisteredTypeLoadingContexts.alreadyEncountered(encounteredCatalogTypes);
            return (PolicySpec)loader.getManagementContext().getTypeRegistry().createSpec(item, context, PolicySpec.class);
        }
        PolicySpec spec = PolicySpec.create((Class)loader.loadClass(versionedId, Policy.class));
        return spec;
    }

    private static EnricherSpec<? extends Enricher> resolveEnricherSpec(String versionedId, BrooklynClassLoadingContext loader, Set<String> encounteredCatalogTypes) {
        RegisteredType item = loader.getManagementContext().getTypeRegistry().get(BundleUpgradeParser.CatalogUpgrades.getTypeUpgradedIfNecessary((ManagementContext)loader.getManagementContext(), (String)versionedId));
        if (item != null && !encounteredCatalogTypes.contains(item.getSymbolicName())) {
            RegisteredTypeLoadingContext context = RegisteredTypeLoadingContexts.alreadyEncountered(encounteredCatalogTypes);
            return (EnricherSpec)loader.getManagementContext().getTypeRegistry().createSpec(item, context, EnricherSpec.class);
        }
        EnricherSpec spec = EnricherSpec.create((Class)loader.loadClass(versionedId, Enricher.class));
        return spec;
    }

    private static LocationSpec<?> resolveLocationSpec(String type, Map<String, Object> brooklynConfig, BrooklynClassLoadingContext loader) {
        LocationSpec spec;
        Maybe javaClass;
        if (brooklynConfig == null) {
            brooklynConfig = MutableMap.of();
        }
        if ((javaClass = loader.tryLoadClass(type, Location.class)).isPresent()) {
            spec = LocationSpec.create((Class)((Class)javaClass.get()));
        } else {
            Maybe loc = loader.getManagementContext().getLocationRegistry().getLocationSpec(type, (Map)brooklynConfig);
            if (loc.isPresent()) {
                spec = (LocationSpec)loc.get();
            } else {
                throw new IllegalStateException("No class or resolver found for location type " + type);
            }
        }
        return spec;
    }
}

