/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser;

import org.jclouds.profitbricks.domain.ServiceFault;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ServiceFaultResponseHandler
extends BaseProfitBricksResponseHandler<ServiceFault> {
    private final ServiceFault.Builder builder = ServiceFault.builder();
    private ServiceFault.Details.Builder detailsBuilder;
    private boolean done = false;

    ServiceFaultResponseHandler() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("detail".equals(qName)) {
            this.detailsBuilder = ServiceFault.Details.builder();
        }
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("faultcode".equals(qName)) {
            this.builder.faultCode(this.textToStringValue());
        } else if ("faultstring".equals(qName)) {
            this.builder.faultString(this.textToStringValue());
        } else if ("faultCode".equals(qName)) {
            this.detailsBuilder.faultCode(ServiceFault.Details.FaultCode.fromValue(this.textToStringValue()));
        } else if ("httpCode".equals(qName)) {
            this.detailsBuilder.httpCode(this.textToIntValue());
        } else if ("message".equals(qName)) {
            this.detailsBuilder.message(this.textToStringValue());
        } else if ("requestId".equals(qName)) {
            this.detailsBuilder.requestId(this.textToIntValue());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.done) {
            return;
        }
        this.setPropertyOnEndTag(qName);
        if ("S:Fault".equals(qName)) {
            this.done = true;
        }
        if ("detail".equals(qName)) {
            this.builder.details(this.detailsBuilder.build());
        }
        this.clearTextBuffer();
    }

    public ServiceFault getResult() {
        return this.builder.build();
    }
}

