/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseSystemMetadataFromHeaders
implements Function<HttpResponse, SystemMetadata> {
    private final DateService dateService;

    @Inject
    public ParseSystemMetadataFromHeaders(DateService dateService) {
        this.dateService = (DateService)Preconditions.checkNotNull((Object)dateService, (Object)"dateService");
    }

    public SystemMetadata apply(HttpResponse from) {
        String[] parts;
        Preconditions.checkNotNull((Object)from, (Object)"http response");
        String meta = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("x-emc-meta"), (Object)"x-emc-meta");
        Map metaMap = Splitter.on((String)", ").withKeyValueSeparator('=').split((CharSequence)meta);
        assert (metaMap.size() >= 12) : String.format("Should be 12 entries in %s", metaMap);
        byte[] md5 = null;
        String wschecksum = from.getFirstHeaderOrNull("x-emc-wschecksum");
        if (wschecksum != null && (parts = wschecksum.split("/"))[0].equalsIgnoreCase("MD5") && parts.length == 3) {
            md5 = BaseEncoding.base16().lowerCase().decode((CharSequence)parts[2]);
        }
        return new SystemMetadata(md5, this.dateService.iso8601SecondsDateParse((String)Preconditions.checkNotNull(metaMap.get("atime"), (Object)"atime")), this.dateService.iso8601SecondsDateParse((String)Preconditions.checkNotNull(metaMap.get("ctime"), (Object)"ctime")), (String)Preconditions.checkNotNull(metaMap.get("gid"), (Object)"gid"), this.dateService.iso8601SecondsDateParse((String)Preconditions.checkNotNull(metaMap.get("itime"), (Object)"itime")), this.dateService.iso8601SecondsDateParse((String)Preconditions.checkNotNull(metaMap.get("mtime"), (Object)"mtime")), Integer.parseInt((String)Preconditions.checkNotNull(metaMap.get("nlink"), (Object)"nlink")), (String)Preconditions.checkNotNull(metaMap.get("objectid"), (Object)"objectid"), (String)Preconditions.checkNotNull(metaMap.get("objname"), (Object)"objname"), (String)Preconditions.checkNotNull(metaMap.get("policyname"), (Object)"policyname"), Long.parseLong((String)Preconditions.checkNotNull(metaMap.get("size"), (Object)"size")), FileType.fromValue((String)Preconditions.checkNotNull(metaMap.get("type"), (Object)"type")), (String)Preconditions.checkNotNull(metaMap.get("uid"), (Object)"uid"));
    }
}

