/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.action;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.policy.action.AbstractScheduledEffectorPolicy;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.DurationPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class PeriodicEffectorPolicy
extends AbstractScheduledEffectorPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicEffectorPolicy.class);
    public static final ConfigKey<Duration> PERIOD = ConfigKeys.builder(Duration.class).name("period").description("The duration between executions of this policy").constraint(DurationPredicates.positive()).defaultValue((Object)Duration.hours((Number)1)).build();

    @Override
    public void start() {
        Duration period = (Duration)Preconditions.checkNotNull((Object)this.config().get(PERIOD), (Object)"The period must be configured for this policy");
        String time = (String)this.config().get(TIME);
        Duration wait = (Duration)this.config().get(WAIT);
        if (time != null) {
            wait = this.getWaitUntil(time);
        } else if (wait == null) {
            wait = period;
        }
        this.schedule(wait);
    }

    @Override
    protected List<Long> resubmitOnResume() {
        List<Long> scheduled = super.resubmitOnResume();
        if (scheduled.isEmpty()) {
            this.start();
        }
        return scheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            super.run();
        }
        finally {
            if (this.isRunning() && this.getManagementContext().isRunning()) {
                Duration period = (Duration)this.config().get(PERIOD);
                String time = (String)this.config().get(TIME);
                if (time == null || time.equalsIgnoreCase("now") || time.equalsIgnoreCase("immediately")) {
                    this.schedule(period);
                } else {
                    Duration wait = this.getWaitUntil(time);
                    this.schedule(wait.upperBound(period));
                }
            }
        }
    }
}

