/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine.pool;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.BasicLocationDefinition;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.entity.machine.pool.ServerPool;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPoolLocation
extends AbstractLocation
implements MachineProvisioningLocation<MachineLocation>,
DynamicLocation<ServerPool, ServerPoolLocation> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerPoolLocation.class);
    public static final ConfigKey<ServerPool> OWNER = ConfigKeys.builder(ServerPool.class, (String)"owner").deprecatedNames(new String[]{"pool.location.owner"}).build();
    @SetFromFlag(value="locationName")
    public static final ConfigKey<String> LOCATION_NAME = ConfigKeys.newStringConfigKey((String)"pool.location.name");
    @SetFromFlag(value="locationRegistrationId")
    private String locationRegistrationId;

    public void init() {
        super.init();
        LOG.debug("Initialising. Owner is: {}", Preconditions.checkNotNull((Object)this.getConfig(OWNER), (Object)OWNER.getName()));
    }

    public void rebind() {
        super.rebind();
        if (this.config().get(LOCATION_NAME) != null) {
            this.register();
        }
    }

    public LocationDefinition register() {
        String locationName = (String)Preconditions.checkNotNull((Object)this.config().get(LOCATION_NAME), (String)"config %s", (Object[])new Object[]{LOCATION_NAME.getName()});
        LocationDefinition check = this.getManagementContext().getLocationRegistry().getDefinedLocationByName(locationName);
        if (check != null) {
            throw new IllegalStateException("Location " + locationName + " is already defined: " + check);
        }
        String locationSpec = String.format("pool:%s", this.getId()) + String.format(":(name=\"%s\")", locationName);
        BasicLocationDefinition definition = new BasicLocationDefinition(locationName, locationSpec, (Map)ImmutableMap.of());
        this.getManagementContext().getLocationRegistry().updateDefinedLocation((LocationDefinition)definition);
        this.locationRegistrationId = definition.getId();
        this.requestPersist();
        return definition;
    }

    public void deregister() {
        if (this.locationRegistrationId != null) {
            this.getManagementContext().getLocationRegistry().removeDefinedLocation(this.locationRegistrationId);
        }
    }

    public ServerPool getOwner() {
        return (ServerPool)this.getConfig(OWNER);
    }

    public MachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        return this.getOwner().claimMachine(flags);
    }

    public MachineProvisioningLocation<MachineLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    public void release(MachineLocation machine) {
        this.getOwner().releaseMachine(machine);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }
}

