/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.api.model.IdentityFluentImpl;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.IdentityListFluent;
import java.util.ArrayList;
import java.util.List;

public class IdentityListFluentImpl<A extends IdentityListFluent<A>>
extends BaseFluent<A>
implements IdentityListFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends Identity, ?>> items = new ArrayList();
    private String kind;
    private VisitableBuilder<? extends ListMeta, ?> metadata;

    public IdentityListFluentImpl() {
    }

    public IdentityListFluentImpl(IdentityList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToItems(Identity ... items) {
        for (Identity item : items) {
            IdentityBuilder builder = new IdentityBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Identity ... items) {
        for (Identity item : items) {
            IdentityBuilder builder = new IdentityBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<Identity> getItems() {
        return IdentityListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<Identity> items) {
        this._visitables.removeAll(this.items);
        this.items.clear();
        if (items != null) {
            for (Identity item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(Identity ... items) {
        this.items.clear();
        if (items != null) {
            for (Identity item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public IdentityListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public IdentityListFluent.ItemsNested<A> addNewItemLike(Identity item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public IdentityListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public IdentityListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public IdentityListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public IdentityListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public IdentityListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityListFluentImpl that = (IdentityListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<IdentityListFluent.MetadataNested<N>>
    implements IdentityListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)IdentityListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends IdentityFluentImpl<IdentityListFluent.ItemsNested<N>>
    implements IdentityListFluent.ItemsNested<N>,
    Nested<N> {
        private final IdentityBuilder builder;

        ItemsNestedImpl(Identity item) {
            this.builder = new IdentityBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.builder = new IdentityBuilder(this);
        }

        @Override
        public N and() {
            return (N)IdentityListFluentImpl.this.addToItems(this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

