/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.ReleaseableLatch;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxConcurrencySensor
implements EntityInitializer {
    private static final Logger log = LoggerFactory.getLogger(MaxConcurrencySensor.class);
    public static final ConfigKey<String> SENSOR_NAME = ConfigKeys.newStringConfigKey("name", "The name of the sensor to create");
    public static final ConfigKey<String> SENSOR_TYPE = ConfigKeys.newConfigKeyWithDefault(AddSensor.SENSOR_TYPE, ReleaseableLatch.class.getName());
    public static final ConfigKey<Integer> MAX_CONCURRENCY = ConfigKeys.newIntegerConfigKey("latch.concurrency.max", "The maximum number of threads that can execute the step for the latch this sensors is used at, in parallel.", Integer.MAX_VALUE);
    private Object maxConcurrency;
    private String sensorName;

    public MaxConcurrencySensor(ConfigBag params) {
        this.sensorName = params.get(SENSOR_NAME);
        this.maxConcurrency = params.getStringKey(MAX_CONCURRENCY.getName());
    }

    public void apply(final EntityLocal entity) {
        final AttributeSensor<ReleaseableLatch> sensor = Sensors.newSensor(ReleaseableLatch.class, this.sensorName);
        ((EntityInternal)entity).getMutableEntityType().addSensor((Sensor<?>)sensor);
        final Task<ReleaseableLatch> resolveValueTask = DependentConfiguration.maxConcurrency(this.maxConcurrency);
        class SetValue
        implements Runnable {
            SetValue() {
            }

            @Override
            public void run() {
                ReleaseableLatch releaseableLatch = (ReleaseableLatch)resolveValueTask.getUnchecked();
                log.debug(this + " setting sensor " + sensor + " to " + releaseableLatch + " on " + entity);
                entity.sensors().set(sensor, (Object)releaseableLatch);
            }
        }
        Task setValueTask = Tasks.builder().displayName("Setting " + sensor + " on " + entity).body(new SetValue()).build();
        Entities.submit((Entity)entity, Tasks.sequential("Resolving and setting " + sensor + " on " + entity, new TaskAdaptable[]{resolveValueTask, setValueTask}));
    }
}

