/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.entity.chef.ChefBashCommands;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.file.ArchiveTasks;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ChefTasks {
    private static final Logger log = LoggerFactory.getLogger(ChefTasks.class);

    public static TaskFactory<?> installChef(String chefDirectory, boolean force) {
        String installCmd = ChefTasks.cdAndRun(chefDirectory, ChefBashCommands.INSTALL_FROM_OPSCODE);
        if (!force) {
            installCmd = BashCommands.alternatives((String[])new String[]{"which chef-solo", installCmd});
        }
        return SshEffectorTasks.ssh((String[])new String[]{installCmd}).summary("install chef");
    }

    public static TaskFactory<?> installCookbooks(final String chefDirectory, final Map<String, String> cookbooksAndUrls, final boolean force) {
        return Tasks.builder().displayName("install " + (cookbooksAndUrls == null ? "0" : Integer.valueOf(cookbooksAndUrls.size())) + " cookbook" + Strings.s(cookbooksAndUrls)).body(new Runnable(){

            @Override
            public void run() {
                Entity e = EffectorTasks.findEntity();
                if (cookbooksAndUrls == null) {
                    throw new IllegalStateException("No cookbooks defined to install at " + e);
                }
                for (String cookbook : cookbooksAndUrls.keySet()) {
                    DynamicTasks.queue(ChefTasks.installCookbook(chefDirectory, cookbook, (String)cookbooksAndUrls.get(cookbook), force));
                }
            }
        }).buildFactory();
    }

    public static TaskFactory<?> installCookbook(final String chefDirectory, final String cookbookName, final String cookbookArchiveUrl, final boolean force) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                TaskBuilder tb = Tasks.builder().displayName("install cookbook " + cookbookName);
                String cookbookDir = Urls.mergePaths((String[])new String[]{chefDirectory, cookbookName});
                String privateTmpDirContainingUnpackedCookbook = Urls.mergePaths((String[])new String[]{chefDirectory, "tmp-" + Strings.makeValidFilename((String)cookbookName) + "-" + Identifiers.makeRandomId((int)4)});
                String destName = null;
                if (ArchiveUtils.ArchiveType.of((String)cookbookArchiveUrl) == ArchiveUtils.ArchiveType.UNKNOWN) {
                    destName = cookbookName + ".tgz";
                    log.debug("Assuming TGZ type for chef cookbook url " + cookbookArchiveUrl + "; it will be downloaded as " + destName);
                }
                tb.add(ArchiveTasks.deploy(null, null, (String)cookbookArchiveUrl, (SshMachineLocation)EffectorTasks.findSshMachine(), (String)privateTmpDirContainingUnpackedCookbook, (boolean)false, null, (String)destName).newTask());
                String installCmd = BashCommands.chain((String[])new String[]{"cd " + privateTmpDirContainingUnpackedCookbook, "COOKBOOK_EXPANDED_DIR=`ls`", BashCommands.requireTest((String)"`ls | wc -w` -eq 1", (String)("The deployed archive " + cookbookArchiveUrl + " must contain exactly one directory")), "mv $COOKBOOK_EXPANDED_DIR '../" + cookbookName + "'", "cd ..", "rm -rf '" + privateTmpDirContainingUnpackedCookbook + "'"});
                installCmd = force ? BashCommands.alternatives((String[])new String[]{"rm -rf " + cookbookDir, installCmd}) : BashCommands.alternatives((String[])new String[]{"ls " + cookbookDir + " > /dev/null 2> /dev/null", installCmd});
                tb.add((TaskAdaptable)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{installCmd}).summary("renaming cookbook dir")).requiringExitCodeZero()).newTask());
                return tb.build();
            }
        };
    }

    protected static String cdAndRun(String targetDirectory, String command) {
        return BashCommands.chain((String[])new String[]{"mkdir -p '" + targetDirectory + "'", "cd '" + targetDirectory + "'", command});
    }

    public static TaskFactory<?> buildChefFile(String runDirectory, String chefDirectory, String phase, Iterable<? extends String> runList, Map<String, Object> optionalAttributes) {
        String phaseRb = "root = '" + runDirectory + "'\nfile_cache_path root\ncookbook_path '" + chefDirectory + "'\n";
        MutableMap phaseJsonMap = MutableMap.of();
        if (optionalAttributes != null) {
            phaseJsonMap.putAll(optionalAttributes);
        }
        if (runList != null) {
            phaseJsonMap.put("run_list", ImmutableList.copyOf(runList));
        }
        Gson json = new GsonBuilder().create();
        String phaseJson = json.toJson((Object)phaseJsonMap);
        return Tasks.sequential((String)("build chef files for " + phase), (TaskFactory[])new TaskFactory[]{SshEffectorTasks.put((String)(Urls.mergePaths((String[])new String[]{runDirectory}) + "/" + phase + ".rb")).contents(phaseRb).createDirectory(), SshEffectorTasks.put((String)(Urls.mergePaths((String[])new String[]{runDirectory}) + "/" + phase + ".json")).contents(phaseJson)});
    }

    public static TaskFactory<?> runChef(String runDir, String phase) {
        return ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{ChefTasks.cdAndRun(runDir, "sudo chef-solo -c " + phase + ".rb -j " + phase + ".json -ldebug")}).summary("run chef for " + phase)).requiringExitCodeZero();
    }
}

