/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityType;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampTypePlanTransformer;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.BundleApi;
import org.apache.brooklyn.rest.api.TypeApi;
import org.apache.brooklyn.rest.domain.BundleInstallationRestResult;
import org.apache.brooklyn.rest.domain.BundleSummary;
import org.apache.brooklyn.rest.domain.SummaryComparators;
import org.apache.brooklyn.rest.domain.TypeDetail;
import org.apache.brooklyn.rest.domain.TypeSummary;
import org.apache.brooklyn.rest.transform.ConfigTransformer;
import org.apache.brooklyn.rest.transform.EffectorTransformer;
import org.apache.brooklyn.rest.transform.SensorTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeTransformer {
    private static final Logger log = LoggerFactory.getLogger(TypeTransformer.class);

    public static <T extends Entity> TypeSummary summary(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        return TypeTransformer.embellish(new TypeSummary(item), item, false, false, b, ub);
    }

    public static TypeDetail detail(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        return TypeTransformer.embellish(new TypeDetail(item), item, true, false, b, ub);
    }

    public static TypeDetail detailIncludingLegacyItemFields(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        return TypeTransformer.embellish(new TypeDetail(item), item, true, true, b, ub);
    }

    private static <T extends TypeSummary> T embellish(T result, RegisteredType item, boolean detail, boolean legacyDetailFields, BrooklynRestResourceUtils b, UriBuilder ub) {
        result.setExtraField("links", TypeTransformer.makeLinks(item, ub));
        if (RegisteredTypes.isTemplate((RegisteredType)item)) {
            result.setExtraField("template", (Object)true);
        }
        if (item.getIconUrl() != null) {
            String tidiedUrl = TypeTransformer.tidyIconLink(b, item, item.getIconUrl(), ub);
            result.setIconUrl(tidiedUrl);
            if (!Objects.equals(item.getIconUrl(), tidiedUrl)) {
                result.setExtraField("iconUrlSource", (Object)item.getIconUrl());
            }
        }
        BrooklynTags.SpecSummary currentSpec = BrooklynTags.SpecSummary.builder().format(StringUtils.isBlank((CharSequence)item.getPlan().getPlanFormat()) ? CampTypePlanTransformer.FORMAT : item.getPlan().getPlanFormat()).summary((StringUtils.isBlank((CharSequence)item.getPlan().getPlanFormat()) ? CampTypePlanTransformer.FORMAT : item.getPlan().getPlanFormat()) + " implementation").contents(item.getPlan().getPlanData()).build();
        List specTag = BrooklynTags.findSpecHierarchyTag((Iterable)item.getTags());
        MutableList specList = MutableList.of((Object)currentSpec);
        if (specTag != null) {
            BrooklynTags.SpecSummary.modifyHeadSpecSummary((List)specList, s -> s.summary.startsWith(s.format) ? "Converted to " + s.summary : (s.summary.contains(s.format) ? s.summary + ", converted" : s.summary + ", converted to " + s.format));
            BrooklynTags.SpecSummary.pushToList((List)specList, (List)specTag);
        }
        result.setExtraField("specList", (Object)specList);
        if (detail) {
            if (RegisteredTypes.isSubtypeOf((RegisteredType)item, Entity.class)) {
                TypeTransformer.embellishEntity(result, item, b);
            } else if (RegisteredTypes.isSubtypeOf((RegisteredType)item, EntityAdjunct.class) || RegisteredTypes.isSubtypeOf((RegisteredType)item, Policy.class) || RegisteredTypes.isSubtypeOf((RegisteredType)item, Enricher.class) || RegisteredTypes.isSubtypeOf((RegisteredType)item, Feed.class)) {
                try {
                    LinkedHashSet config = Sets.newLinkedHashSet();
                    AbstractBrooklynObjectSpec spec = b.getTypeRegistry().createSpec(item, null, null);
                    AtomicInteger priority = new AtomicInteger(0);
                    for (SpecParameter input : spec.getParameters()) {
                        config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transform());
                    }
                    result.setExtraField("config", (Object)config);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.trace("Unable to create spec for " + item + ": " + e, (Throwable)e);
                }
            } else if (RegisteredTypes.isSubtypeOf((RegisteredType)item, Location.class)) {
                result.setExtraField("config", Collections.emptySet());
            }
        }
        if (legacyDetailFields) {
            result.setExtraField("planYaml", item.getPlan() == null ? null : item.getPlan().getPlanData());
            result.setExtraField("name", (Object)item.getDisplayName());
        }
        return result;
    }

    protected static <T extends TypeSummary> void embellishEntity(T result, RegisteredType item, BrooklynRestResourceUtils b) {
        block6: {
            try {
                LinkedHashSet config = Sets.newLinkedHashSet();
                TreeSet sensors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
                TreeSet effectors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
                EntitySpec spec = (EntitySpec)b.getTypeRegistry().createSpec(item, null, EntitySpec.class);
                EntityDynamicType typeMap = BrooklynTypes.getDefinedEntityType((Class)spec.getType());
                EntityType type = typeMap.getSnapshot();
                AtomicInteger priority = new AtomicInteger();
                for (SpecParameter input : spec.getParameters()) {
                    config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transform());
                }
                for (Sensor x : type.getSensors()) {
                    sensors.add(SensorTransformer.sensorSummaryForCatalog(x));
                }
                for (Sensor x : type.getEffectors()) {
                    effectors.add(EffectorTransformer.effectorSummaryForCatalog(b.mgmt(), x));
                }
                result.setExtraField("config", (Object)config);
                result.setExtraField("sensors", (Object)sensors);
                result.setExtraField("effectors", (Object)effectors);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (item.getSuperTypes().contains(Entity.class)) {
                    log.warn("Unable to create spec for " + item + ": " + e, (Throwable)e);
                }
                if (!log.isTraceEnabled()) break block6;
                log.trace("Unable to create spec for " + item + ": " + e, (Throwable)e);
            }
        }
    }

    public static BundleSummary bundleSummary(BrooklynRestResourceUtils brooklyn, ManagedBundle b, UriBuilder baseUriBuilder, ManagementContext mgmt, boolean detail) {
        Optional<String> iconUrl;
        BundleSummary result = new BundleSummary((OsgiBundleWithUrl)b);
        if (detail) {
            result.setExtraField("osgiVersion", (Object)b.getOsgiVersionString());
            result.setExtraField("checksum", (Object)b.getChecksum());
            if (b.getFormat() != null) {
                result.setExtraField("format", (Object)b.getFormat());
            }
        }
        if (detail) {
            for (RegisteredType t : mgmt.getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle((OsgiBundleWithUrl)b))) {
                result.addType(TypeTransformer.summary(brooklyn, t, baseUriBuilder));
            }
        }
        if ((iconUrl = Optional.ofNullable(BrooklynTags.findFirstNamedStringTag((String)"icon_url", (Iterable)b.tags().getTags())).map(BrooklynTags.NamedStringTag::getContents)).isPresent()) {
            result.setExtraField("iconUrl", (Object)WebResourceUtils.serviceUriBuilder(baseUriBuilder, BundleApi.class, "getIcon").build(new Object[]{b.getSymbolicName(), b.getOsgiVersionString()}));
        }
        return result;
    }

    public static BundleSummary bundleDetails(BrooklynRestResourceUtils brooklyn, ManagedBundle b, UriBuilder baseUriBuilder, ManagementContext mgmt) {
        return TypeTransformer.bundleSummary(brooklyn, b, baseUriBuilder, mgmt, true);
    }

    public static BundleInstallationRestResult bundleInstallationResult(OsgiBundleInstallationResult in, ManagementContext mgmt, BrooklynRestResourceUtils brooklynU, UriInfo ui) {
        BundleInstallationRestResult result = new BundleInstallationRestResult(in.getMessage(), in.getVersionedName() != null ? in.getVersionedName().toString() : "", in.getCode());
        for (RegisteredType t : in.getTypesInstalled()) {
            TypeSummary summary = TypeTransformer.summary(brooklynU, t, ui.getBaseUriBuilder());
            result.getTypes().put(t.getId(), summary);
        }
        return result;
    }

    public static BundleInstallationRestResult bundleInstallationResultLegacyItemDetails(OsgiBundleInstallationResult in, ManagementContext mgmt, BrooklynRestResourceUtils brooklynU, UriInfo ui) {
        BundleInstallationRestResult result = new BundleInstallationRestResult(in.getMessage(), in.getVersionedName() != null ? in.getVersionedName().toString() : "", in.getCode());
        for (RegisteredType t : in.getTypesInstalled()) {
            TypeDetail summary = TypeTransformer.detailIncludingLegacyItemFields(brooklynU, t, ui.getBaseUriBuilder());
            result.getTypes().put(t.getId(), summary);
        }
        return result;
    }

    protected static Map<String, URI> makeLinks(RegisteredType item, UriBuilder ub) {
        return MutableMap.of().addIfNotNull((Object)"self", (Object)TypeTransformer.getSelfLink(item, ub));
    }

    private static URI getSelfLink(RegisteredType item, UriBuilder ub) {
        Maybe bundleM = VersionedName.parseMaybe((String)item.getContainingBundle(), (boolean)true);
        if (bundleM.isPresent()) {
            return WebResourceUtils.serviceUriBuilder(ub, BundleApi.class, "getTypeExplicitVersion").build(new Object[]{((VersionedName)bundleM.get()).getSymbolicName(), ((VersionedName)bundleM.get()).getVersionString(), item.getSymbolicName(), item.getVersion()});
        }
        return WebResourceUtils.serviceUriBuilder(ub, TypeApi.class, "detail").build(new Object[]{item.getSymbolicName(), item.getVersion()});
    }

    private static String tidyIconLink(BrooklynRestResourceUtils b, RegisteredType item, String iconUrl, UriBuilder ub) {
        if (b.isUrlServerSideAndSafe(iconUrl)) {
            Maybe bundleM = VersionedName.parseMaybe((String)item.getContainingBundle(), (boolean)true);
            if (bundleM.isAbsent()) {
                return WebResourceUtils.serviceUriBuilder(ub, BundleApi.class, "getTypeExplicitVersionIcon").build(new Object[]{((VersionedName)bundleM.get()).getSymbolicName(), ((VersionedName)bundleM.get()).getVersionString(), item.getSymbolicName(), item.getVersion()}).toString();
            }
            return WebResourceUtils.serviceUriBuilder(ub, TypeApi.class, "icon").build(new Object[]{item.getSymbolicName(), item.getVersion()}).toString();
        }
        return iconUrl;
    }
}

