/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.PolicyMemento;
import org.apache.brooklyn.api.objs.HighlightTuple;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractMemento;

public class BasicPolicyMemento
extends AbstractMemento
implements PolicyMemento,
Serializable {
    private static final long serialVersionUID = -4025337943126838761L;
    private Map<String, Object> config;
    private Map<String, Object> fields;
    private Map<String, HighlightTuple> highlights;

    public static Builder builder() {
        return new Builder();
    }

    private BasicPolicyMemento() {
    }

    protected BasicPolicyMemento(Builder builder) {
        super(builder);
        this.config = this.toPersistedMap(builder.config);
        this.highlights = this.toPersistedMap(builder.highlights);
    }

    @Override
    @Deprecated
    protected void setCustomFields(Map<String, Object> fields) {
        this.fields = this.toPersistedMap(fields);
    }

    @Deprecated
    public Map<String, Object> getCustomFields() {
        return this.fromPersistedMap(this.fields);
    }

    public Map<String, Object> getConfig() {
        return this.fromPersistedMap(this.config);
    }

    public Map<String, HighlightTuple> getHighlights() {
        return this.highlights;
    }

    @Override
    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("config", Sanitizer.sanitize(this.getConfig())).add("highlights", this.highlights);
    }

    public static class Builder
    extends AbstractMemento.Builder<Builder> {
        protected Map<String, Object> config = Maps.newLinkedHashMap();
        protected Map<String, HighlightTuple> highlights = Maps.newLinkedHashMap();

        public Builder from(PolicyMemento other) {
            super.from((Memento)other);
            this.config.putAll(other.getConfig());
            this.highlights.putAll(other.getHighlights());
            return this;
        }

        public Builder config(Map<String, ?> vals) {
            this.config.putAll(vals);
            return this;
        }

        public Builder highlights(Map<String, HighlightTuple> vals) {
            this.highlights.putAll(vals);
            return this;
        }

        public PolicyMemento build() {
            return new BasicPolicyMemento(this);
        }
    }
}

