/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInitializer
extends EntityInitializers.InitializerPatternWithConfigKeys
implements WorkflowCommonConfig {
    public static final Logger log = LoggerFactory.getLogger(WorkflowInitializer.class);
    public static final ConfigKey<String> WORKFLOW_NAME = ConfigKeys.newStringConfigKey("name", "Name of the workflow to run as part of entity initialization", "Workflow initializer");
    public static final ConfigKey<Object> DELAY = ConfigKeys.newConfigKey(Object.class, "delay", "Either false to run synchronously during entity initialization (the default), true to run after management is fully started, or a duration to delay that long before running");
    private EntityLocal entity;

    public WorkflowInitializer() {
    }

    public WorkflowInitializer(ConfigBag params) {
        super(params);
    }

    public WorkflowInitializer(Map<?, ?> params) {
        this(ConfigBag.newInstance(params));
    }

    public void apply(EntityLocal entity) {
        Duration delayDuration;
        boolean delayed;
        this.entity = entity;
        Object delay = this.initParams().get(DELAY);
        if (delay == null || Boolean.FALSE.equals(delay) || delay instanceof String && (Strings.isBlank((CharSequence)((String)delay)) || "false".equalsIgnoreCase((String)delay) || "sync".equalsIgnoreCase((String)delay))) {
            delayed = false;
            delayDuration = null;
        } else {
            delayed = true;
            delayDuration = Boolean.TRUE.equals(delay) || delay instanceof String && ("true".equalsIgnoreCase((String)delay) || "async".equalsIgnoreCase((String)delay)) ? Duration.ZERO : Duration.parse((String)delay.toString());
        }
        String delaySummary = delayed ? (delayDuration.isPositive() ? "" + delayDuration + " " : "") + "after management start" : null;
        Callable<Object> callable = () -> {
            try {
                Task submitted;
                WorkflowExecutionContext w = WorkflowExecutionContext.newInstancePersisted((BrooklynObject)entity, WorkflowExecutionContext.WorkflowContextType.OTHER, this.initParam(WORKFLOW_NAME) + (delayed ? " (" + delaySummary + ")" : ""), ConfigBag.newInstanceCopying(this.initParams()), null, null, (Map<String, Object>)MutableMap.of((Object)"tags", (Object)MutableList.of((Object)BrooklynTaskTags.ENTITY_INITIALIZATION)));
                Maybe<Task<Object>> task = w.getTask(true);
                if (task.isAbsent()) {
                    log.debug("Skipping workflow initializer on " + entity + ", condition not met: " + this.initParams());
                    if (delayed) {
                        DynamicTasks.queue(Tasks.warning("Skipping: condition not met", null));
                    }
                    return null;
                }
                log.debug("Submitting workflow initializer on " + entity + ": " + this.initParams());
                w.persist();
                if (delayed) {
                    DynamicTasks.queue(Tasks.create("Delaying until " + delaySummary, () -> {
                        ((EntityInternal)entity).getManagementContext().waitForManagementStartupComplete(null);
                        if (delayDuration.isPositive()) {
                            Time.sleep((Duration)delayDuration);
                        }
                    }));
                }
                Task task2 = submitted = delayed ? (Task)DynamicTasks.queue((TaskAdaptable)task.get()) : (Task)Entities.submit((Entity)entity, (TaskAdaptable)task.get());
                if (delayed) {
                    DynamicTasks.waitForLast();
                }
                Object result = submitted.getUnchecked();
                log.debug("Applied workflow initializer on " + entity + ", result: " + result);
                return result;
            }
            catch (Exception e) {
                log.warn("Error running workflow initializer (rethrowing): " + e, (Throwable)e);
                throw Exceptions.propagate((Throwable)e);
            }
        };
        if (delayed) {
            Entities.submit((Entity)entity, Tasks.builder().displayName(this.initParam(WORKFLOW_NAME)).dynamic(true).body(callable).build());
        } else {
            try {
                callable.call();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }
}

