/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.compute.ComputeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildEntityCustomizer
extends BasicJcloudsLocationCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(ChildEntityCustomizer.class);
    @SetFromFlag(value="childSpec")
    public static final ConfigKey<EntitySpec<?>> CHILD_ENTITY_SPEC = ConfigKeys.newConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"child.entitySpec", (String)"The specification for the child entity to be created");
    @SetFromFlag(value="create")
    public static final ConfigKey<Boolean> CREATE_CHILD_ENTITY = ConfigKeys.newBooleanConfigKey((String)"child.create", (String)"Whether the child entity should be created", (Boolean)Boolean.TRUE);

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
        EntitySpec spec = (EntitySpec)this.config().get(CHILD_ENTITY_SPEC);
        Boolean create = (Boolean)this.config().get(CREATE_CHILD_ENTITY);
        Duration timeout = (Duration)this.config().get(BrooklynConfigKeys.START_TIMEOUT);
        Entity parent = this.getCallerContext(machine);
        if (Boolean.TRUE.equals(create) && spec != null) {
            LOG.info("Creating child entity for {} in {}", (Object)parent, (Object)machine);
            Entity child = this.getBrooklynManagementContext().getEntityManager().createEntity(spec);
            child.setParent(parent);
            Task start = Entities.invokeEffectorWithArgs((Entity)parent, (Entity)child, (Effector)Startable.START, (Object[])new Object[]{ImmutableList.of((Object)machine)});
            if (!start.blockUntilEnded(timeout)) {
                throw new IllegalStateException(String.format("Timed out while starting child entity for %s", parent));
            }
        }
    }
}

