/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.MemoryUsageTracker;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynTaskTags
extends TaskTags {
    private static final Logger log = LoggerFactory.getLogger(BrooklynTaskTags.class);
    public static final String BROOKLYN_SERVER_TASK_TAG = "BROOKLYN-SERVER";
    public static final Object TOP_LEVEL_TASK = "TOP-LEVEL";
    public static final Object ENTITY_INITIALIZATION = "INITIALIZATION";
    public static final Object ENTITY_DESTRUCTION = "DESTRUCTION";
    public static final String EFFECTOR_TAG = "EFFECTOR";
    public static final String SENSOR_TAG = "SENSOR";
    public static final String WORKFLOW_TAG = "WORKFLOW";
    public static final String NON_TRANSIENT_TASK_TAG = "NON-TRANSIENT";
    public static final String TRANSIENT_TASK_TAG = "TRANSIENT";
    public static final String IMMEDIATE_TASK_TAG = "IMMEDIATE";
    public static final String ERROR_HANDLED_BY_TASK_TAG = "ERROR_HANDLED_BY";
    public static final String CONTEXT_ENTITY = "contextEntity";
    public static final String CALLER_ENTITY = "callerEntity";
    public static final String TARGET_ENTITY = "targetEntity";
    public static final String CONTEXT_ADJUNCT = "contextAdjunct";
    public static final String STREAM_STDIN = "stdin";
    public static final String STREAM_STDOUT = "stdout";
    public static final String STREAM_STDERR = "stderr";
    public static final String STREAM_ENV = "env";
    private static final Maybe<ByteArrayOutputStream> STREAM_GARBAGE_COLLECTED_MAYBE = Maybe.of((Object)Streams.byteArrayOfString((String)"<contents-garbage-collected>"));

    public static WrappedEntity tagForContextEntity(Entity entity) {
        return new WrappedEntity(CONTEXT_ENTITY, entity);
    }

    public static WrappedEntity tagForCallerEntity(Entity entity) {
        return new WrappedEntity(CALLER_ENTITY, entity);
    }

    public static WrappedEntity tagForTargetEntity(Entity entity) {
        return new WrappedEntity(TARGET_ENTITY, entity);
    }

    public static WrappedObject<EntityAdjunct> tagForContextAdjunct(EntityAdjunct adjunct) {
        return new WrappedObject<EntityAdjunct>(CONTEXT_ADJUNCT, adjunct);
    }

    public static WrappedEntity getWrappedEntityTagOfType(Task<?> t, String wrappingType) {
        if (t == null) {
            return null;
        }
        return BrooklynTaskTags.getWrappedEntityTagOfType(BrooklynTaskTags.getTagsFast(t), wrappingType);
    }

    public static WrappedEntity getWrappedEntityTagOfType(Collection<?> tags, String wrappingType) {
        if (tags == null) {
            return null;
        }
        for (Object x : tags) {
            if (!(x instanceof WrappedEntity) || !((WrappedEntity)x).wrappingType.equals(wrappingType)) continue;
            return (WrappedEntity)x;
        }
        return null;
    }

    public static <T> WrappedObject<T> getWrappedObjectTagOfType(Collection<?> tags, String wrappingType, Class<T> type) {
        if (tags == null) {
            return null;
        }
        for (Object x : tags) {
            if (!(x instanceof WrappedObject) || !((WrappedObject)x).wrappingType.equals(wrappingType) || !type.isInstance(((WrappedObject)x).object)) continue;
            return (WrappedObject)x;
        }
        return null;
    }

    public static <T> T getUnwrappedObjectTagOfType(Collection<?> tags, String wrappingType, Class<T> type) {
        WrappedObject<T> result = BrooklynTaskTags.getWrappedObjectTagOfType(tags, wrappingType, type);
        return result != null ? (T)result.unwrap() : null;
    }

    public static Entity getWrappedEntityOfType(Task<?> t, String wrappingType) {
        WrappedEntity wrapper = BrooklynTaskTags.getWrappedEntityTagOfType(t, wrappingType);
        return wrapper == null ? null : wrapper.entity;
    }

    public static Entity getWrappedEntityOfType(Collection<?> tags, String wrappingType) {
        WrappedEntity wrapper = BrooklynTaskTags.getWrappedEntityTagOfType(tags, wrappingType);
        return wrapper == null ? null : wrapper.entity;
    }

    public static Entity getContextEntity(Task<?> task) {
        return BrooklynTaskTags.getWrappedEntityOfType(task, CONTEXT_ENTITY);
    }

    public static EntityAdjunct getContextEntityAdjunct(Task<?> task, boolean recursively) {
        WrappedObject<EntityAdjunct> result = BrooklynTaskTags.getWrappedObjectTagOfType(BrooklynTaskTags.getTagsFast(task), CONTEXT_ADJUNCT, EntityAdjunct.class);
        if (result == null) {
            if (recursively && task != null) {
                return BrooklynTaskTags.getContextEntityAdjunct(task.getSubmittedByTask(), recursively);
            }
            return null;
        }
        return (EntityAdjunct)((WrappedObject)result).object;
    }

    public static Object getTargetOrContextEntityTag(Task<?> task) {
        if (task == null) {
            return null;
        }
        WrappedEntity result = BrooklynTaskTags.getWrappedEntityTagOfType(task, CONTEXT_ENTITY);
        if (result != null) {
            return result;
        }
        result = BrooklynTaskTags.getWrappedEntityTagOfType(task, TARGET_ENTITY);
        if (result != null) {
            return result;
        }
        result = Tasks.tag(task, Entity.class, false);
        if (result != null) {
            return result;
        }
        return null;
    }

    public static Entity getTargetOrContextEntity(Task<?> t) {
        if (t == null) {
            return null;
        }
        Entity result = BrooklynTaskTags.getWrappedEntityOfType(t, CONTEXT_ENTITY);
        if (result != null) {
            return result;
        }
        result = BrooklynTaskTags.getWrappedEntityOfType(t, TARGET_ENTITY);
        if (result != null) {
            log.warn("Context entity found by looking at target entity tag, not context entity");
            return result;
        }
        result = Tasks.tag(t, Entity.class, false);
        if (result != null) {
            log.warn("Context entity found by looking at 'Entity' tag, not wrapped entity");
        }
        return result;
    }

    public static Set<Task<?>> getTasksInEntityContext(ExecutionManager em, Entity e) {
        return em.getTasksWithTag((Object)BrooklynTaskTags.tagForContextEntity(e));
    }

    public static Set<Task<?>> getTasksInAdjunctContext(ExecutionManager em, EntityAdjunct a) {
        return em.getTasksWithTag(BrooklynTaskTags.tagForContextAdjunct(a));
    }

    public static ManagementContext getManagementContext(Task<?> task) {
        if (task == null) {
            return null;
        }
        for (Object tag : BrooklynTaskTags.getTagsFast(task)) {
            if (!(tag instanceof ManagementContext)) continue;
            return (ManagementContext)tag;
        }
        return BrooklynTaskTags.getManagementContext(task.getSubmittedByTask());
    }

    public static WrappedStream tagForStream(String streamType, ByteArrayOutputStream stream) {
        return new WrappedStream(streamType, stream);
    }

    public static WrappedStream tagForStreamSoft(String streamType, ByteArrayOutputStream stream) {
        MemoryUsageTracker.SOFT_REFERENCES.track((Object)stream, (long)stream.size());
        Maybe softStream = Maybe.softThen((Object)stream, STREAM_GARBAGE_COLLECTED_MAYBE);
        return new WrappedStream(streamType, (Supplier<String>)Suppliers.compose((Function)Functions.toStringFunction(), (Supplier)softStream), (Supplier<Integer>)Suppliers.compose((Function)Streams.sizeFunction(), (Supplier)softStream));
    }

    public static WrappedStream tagForStream(String streamType, Supplier<String> contents, Supplier<Integer> size) {
        return new WrappedStream(streamType, contents, size);
    }

    public static WrappedStream tagForEnvStream(String streamEnv, Map<?, ?> env) {
        StringBuilder sb = new StringBuilder();
        Sanitizer.sanitizeMapToString(env, sb);
        return BrooklynTaskTags.tagForStream(STREAM_ENV, Streams.byteArrayOfString((String)sb.toString()));
    }

    public static Set<WrappedStream> streams(Task<?> task) {
        LinkedHashSet<WrappedStream> result = new LinkedHashSet<WrappedStream>();
        for (Object tag : BrooklynTaskTags.getTagsFast(task)) {
            if (!(tag instanceof WrappedStream)) continue;
            result.add((WrappedStream)tag);
        }
        return ImmutableSet.copyOf(result);
    }

    public static WrappedStream stream(Task<?> task, String streamType) {
        if (task == null) {
            return null;
        }
        for (Object tag : BrooklynTaskTags.getTagsFast(task)) {
            if (!(tag instanceof WrappedStream) || !((WrappedStream)tag).streamType.equals(streamType)) continue;
            return (WrappedStream)tag;
        }
        return null;
    }

    public static <TR, T extends Task<TR>> T setInessential(T task) {
        return BrooklynTaskTags.addTagDynamically(task, "inessential");
    }

    public static <TR, T extends Task<TR>> T setTransient(T task) {
        return BrooklynTaskTags.addTagDynamically(task, TRANSIENT_TASK_TAG);
    }

    public static boolean isTransient(Task<?> task) {
        if (BrooklynTaskTags.hasTag(task, TRANSIENT_TASK_TAG)) {
            return true;
        }
        if (BrooklynTaskTags.hasTag(task, NON_TRANSIENT_TASK_TAG)) {
            return false;
        }
        if (task.getSubmittedByTask() != null) {
            return BrooklynTaskTags.isTransient(task.getSubmittedByTask());
        }
        return false;
    }

    public static boolean isSubTask(Task<?> task) {
        return BrooklynTaskTags.hasTag(task, "SUB-TASK");
    }

    public static boolean isEffectorTask(Task<?> task) {
        return BrooklynTaskTags.hasTag(task, EFFECTOR_TAG);
    }

    public static EffectorCallTag tagForEffectorCall(Entity entity, String effectorName, ConfigBag parameters) {
        return new EffectorCallTag(entity.getId(), effectorName, parameters);
    }

    public static WorkflowTaskTag tagForWorkflow(WorkflowExecutionContext workflow) {
        WorkflowTaskTag t = new WorkflowTaskTag();
        t.applicationId = workflow.getEntity().getApplicationId();
        t.entityId = workflow.getEntity().getId();
        t.workflowId = workflow.getWorkflowId();
        return t;
    }

    public static WorkflowTaskTag tagForWorkflow(WorkflowStepInstanceExecutionContext workflowStep) {
        WorkflowTaskTag t = BrooklynTaskTags.tagForWorkflow(workflowStep.getWorkflowExectionContext());
        t.stepIndex = workflowStep.getStepIndex();
        return t;
    }

    public static WorkflowTaskTag tagForWorkflowSubStep(WorkflowStepInstanceExecutionContext parentStep, int subStepIndex) {
        WorkflowTaskTag t = BrooklynTaskTags.tagForWorkflow(parentStep.getWorkflowExectionContext());
        t.stepIndex = parentStep.getStepIndex();
        t.subStepIndex = subStepIndex;
        return t;
    }

    public static WorkflowTaskTag tagForWorkflowStepErrorHandler(WorkflowStepInstanceExecutionContext workflowStep, Integer errorHandlerIndex, String errorHandlerForTask) {
        WorkflowTaskTag t = BrooklynTaskTags.tagForWorkflow(workflowStep.getWorkflowExectionContext());
        t.stepIndex = workflowStep != null ? Integer.valueOf(workflowStep.getStepIndex()) : null;
        t.subStepIndex = errorHandlerIndex;
        t.errorHandlerIndex = errorHandlerIndex;
        t.errorHandlerForTask = errorHandlerForTask;
        if (Strings.isBlank((CharSequence)t.errorHandlerForTask)) {
            t.errorHandlerForTask = "task-unavailable";
        }
        return t;
    }

    public static WorkflowTaskTag tagForWorkflowStepErrorHandler(WorkflowExecutionContext context) {
        WorkflowTaskTag t = BrooklynTaskTags.tagForWorkflow(context);
        t.errorHandlerForTask = context.getTaskId();
        if (Strings.isBlank((CharSequence)t.errorHandlerForTask)) {
            t.errorHandlerForTask = "task-unavailable";
        }
        return t;
    }

    public static Map<String, String> tagForErrorHandledBy(Task<?> handler) {
        return ImmutableMap.of((Object)ERROR_HANDLED_BY_TASK_TAG, (Object)handler.getId());
    }

    public static boolean isInEffectorTask(Task<?> task, @Nullable Entity entity, @Nullable Effector<?> effector, boolean allowNestedEffectorCalls) {
        for (Task t = task; t != null; t = t.getSubmittedByTask()) {
            Set tags = t.getTags();
            if (!tags.contains(EFFECTOR_TAG)) continue;
            for (Object tag : tags) {
                if (!(tag instanceof EffectorCallTag)) continue;
                EffectorCallTag et = (EffectorCallTag)tag;
                if (entity != null && !et.getEntityId().equals(entity.getId()) || effector != null && !et.getEffectorName().equals(effector.getName())) continue;
                return true;
            }
            if (allowNestedEffectorCalls) continue;
            return false;
        }
        return false;
    }

    @Beta
    public static Task<?> getClosestEffectorTask(Task<?> child, Effector<?> effector) {
        for (Task t = child; t != null; t = t.getSubmittedByTask()) {
            Set tags = t.getTags();
            if (!tags.contains(EFFECTOR_TAG)) continue;
            for (Object tag : tags) {
                if (!(tag instanceof EffectorCallTag)) continue;
                EffectorCallTag et = (EffectorCallTag)tag;
                if (effector != null && !et.getEffectorName().equals(effector.getName())) continue;
                return t;
            }
        }
        return null;
    }

    public static EffectorCallTag getEffectorCallTag(Task<?> task, boolean recurse) {
        for (Task t = task; t != null; t = t.getSubmittedByTask()) {
            for (Object tag : BrooklynTaskTags.getTagsFast(task)) {
                if (!(tag instanceof EffectorCallTag)) continue;
                return (EffectorCallTag)tag;
            }
            if (recurse) continue;
            return null;
        }
        return null;
    }

    public static WorkflowTaskTag getWorkflowTaskTag(Task<?> task, boolean recurse) {
        for (Task t = task; t != null; t = t.getSubmittedByTask()) {
            for (Object tag : BrooklynTaskTags.getTagsFast(task)) {
                if (!(tag instanceof WorkflowTaskTag)) continue;
                return (WorkflowTaskTag)tag;
            }
            if (recurse) continue;
            return null;
        }
        return null;
    }

    public static String getEffectorName(Task<?> task) {
        EffectorCallTag result = BrooklynTaskTags.getEffectorCallTag(task, true);
        return result == null ? null : result.getEffectorName();
    }

    public static ConfigBag getEffectorParameters(Task<?> task) {
        EffectorCallTag result = BrooklynTaskTags.getEffectorCallTag(task, true);
        return result == null ? null : result.getParameters();
    }

    public static ConfigBag getCurrentEffectorParameters() {
        return BrooklynTaskTags.getEffectorParameters(Tasks.current());
    }

    public static void setEffectorParameters(Task<?> task, ConfigBag parameters) {
        EffectorCallTag result = BrooklynTaskTags.getEffectorCallTag(task, true);
        if (result == null) {
            throw new IllegalStateException("No EffectorCallTag found, is the task an effector? Task: " + task);
        }
        result.setParameters(parameters);
    }

    public static EntitlementContext getEntitlement(Task<?> task) {
        if (task == null) {
            return null;
        }
        return BrooklynTaskTags.getEntitlement(BrooklynTaskTags.getTagsFast(task));
    }

    public static EntitlementContext getEntitlement(Collection<?> tags) {
        if (tags == null) {
            return null;
        }
        for (Object tag : tags) {
            if (!(tag instanceof EntitlementTag)) continue;
            return ((EntitlementTag)tag).entitlementContext;
        }
        return null;
    }

    public static EntitlementContext getEntitlement(EntitlementTag tag) {
        if (tag == null) {
            return null;
        }
        return tag.entitlementContext;
    }

    public static EntitlementTag tagForEntitlement(EntitlementContext context) {
        EntitlementTag tag = new EntitlementTag();
        tag.entitlementContext = context;
        return tag;
    }

    public static ExecutionContext getExecutionContext(Collection<?> tags) {
        EntityAdjunct ea = BrooklynTaskTags.getUnwrappedObjectTagOfType(tags, CONTEXT_ADJUNCT, EntityAdjunct.class);
        if (ea instanceof AbstractEntityAdjunct) {
            return ((AbstractEntityAdjunct)ea).getExecutionContext();
        }
        Entity e = BrooklynTaskTags.getWrappedEntityOfType(tags, CONTEXT_ENTITY);
        if (e == null) {
            e = BrooklynTaskTags.getWrappedEntityOfType(tags, TARGET_ENTITY);
        }
        if (e instanceof EntityInternal) {
            return ((EntityInternal)e).getExecutionContext();
        }
        return null;
    }

    public static ExecutionContext getExecutionContext(Task<?> t) {
        return BrooklynTaskTags.getExecutionContext(BrooklynTaskTags.getTagsFast(t));
    }

    public static ExecutionContext getCurrentExecutionContext() {
        ExecutionContext result;
        Task t = Tasks.current();
        ExecutionContext executionContext = result = t != null ? BrooklynTaskTags.getExecutionContext(t) : null;
        if (result == null) {
            result = BasicExecutionContext.getCurrentExecutionContext();
        }
        return result;
    }

    public static class EntitlementTag {
        private EntitlementContext entitlementContext;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WorkflowTaskTag {
        protected String applicationId;
        protected String entityId;
        protected String workflowId;
        protected Integer stepIndex;
        protected String supersededByTaskId;
        protected String errorHandlerForTask;
        protected Integer errorHandlerIndex;
        protected Integer subStepIndex;

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getWorkflowId() {
            return this.workflowId;
        }

        public Integer getStepIndex() {
            return this.stepIndex;
        }

        public String getSupersededByTaskId() {
            return this.supersededByTaskId;
        }

        public void setSupersededByTaskId(String supersededByTaskId) {
            this.supersededByTaskId = supersededByTaskId;
        }

        public Integer getErrorHandlerIndex() {
            return this.errorHandlerIndex;
        }

        public String toString() {
            return "WorkflowTaskTag{applicationId='" + this.applicationId + '\'' + ", entityId='" + this.entityId + '\'' + ", workflowId='" + this.workflowId + '\'' + ", stepIndex=" + this.stepIndex + ", supersededByTaskId='" + this.supersededByTaskId + '\'' + ", errorHandlerForTask='" + this.errorHandlerForTask + '\'' + ", errorHandlerIndex=" + this.errorHandlerIndex + '}';
        }
    }

    public static class EffectorCallTag {
        protected final String entityId;
        protected final String effectorName;
        protected Map<String, Object> effectorParams;
        protected transient ConfigBag parameters;

        protected EffectorCallTag(String entityId, String effectorName, ConfigBag parameters) {
            this.entityId = (String)Preconditions.checkNotNull((Object)entityId, (Object)"entityId");
            this.effectorName = (String)Preconditions.checkNotNull((Object)effectorName, (Object)"effectorName");
            this.setParameters(parameters);
        }

        public String toString() {
            return "EFFECTOR@" + this.entityId + ":" + this.effectorName;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.entityId, this.effectorName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EffectorCallTag)) {
                return false;
            }
            EffectorCallTag other = (EffectorCallTag)obj;
            return Objects.equal((Object)this.entityId, (Object)other.entityId) && Objects.equal((Object)this.effectorName, (Object)other.effectorName) && Objects.equal(this.effectorParams, other.effectorParams);
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getEffectorName() {
            return this.effectorName;
        }

        public ConfigBag getParameters() {
            return this.parameters;
        }

        public void setParameters(ConfigBag parameters) {
            this.parameters = parameters;
            this.effectorParams = MutableMap.copyOf(parameters.getAllConfig());
        }

        public Map<String, Object> getEffectorParams() {
            return this.effectorParams;
        }
    }

    public static class WrappedStream {
        public final String streamType;
        public final Supplier<String> streamContents;
        public final Supplier<Integer> streamSize;

        protected WrappedStream(String streamType, Supplier<String> streamContents, Supplier<Integer> streamSize) {
            Preconditions.checkNotNull((Object)streamType);
            Preconditions.checkNotNull(streamContents);
            this.streamType = streamType;
            this.streamContents = streamContents;
            this.streamSize = streamSize != null ? streamSize : Suppliers.ofInstance((Object)((String)streamContents.get()).length());
        }

        protected WrappedStream(String streamType, ByteArrayOutputStream stream) {
            Preconditions.checkNotNull((Object)streamType);
            Preconditions.checkNotNull((Object)stream);
            this.streamType = streamType;
            this.streamContents = Strings.toStringSupplier((Object)stream);
            this.streamSize = Streams.sizeSupplier((ByteArrayOutputStream)stream);
        }

        @JsonProperty
        public Integer getStreamSize() {
            return (Integer)this.streamSize.get();
        }

        @JsonProperty(value="streamContents")
        public String getStreamContentsAbbreviated() {
            if ((Integer)this.streamSize.get() > 8192) {
                return "<contents-too-large>";
            }
            return Strings.maxlenWithEllipsis((String)((String)this.streamContents.get()), (int)80);
        }

        public String toString() {
            return "Stream[" + this.streamType + "/" + Strings.makeSizeString((long)((Integer)this.streamSize.get()).intValue()) + "]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.streamContents, this.streamType});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WrappedStream)) {
                return false;
            }
            return Objects.equal(this.streamContents, ((WrappedStream)obj).streamContents) && Objects.equal((Object)this.streamType, (Object)((WrappedStream)obj).streamType);
        }
    }

    public static class WrappedObject<T>
    extends WrappedItem<T> {
        private final T object;

        protected WrappedObject(String wrappingType, T object) {
            super(wrappingType);
            this.object = Preconditions.checkNotNull(object);
        }

        @Override
        public T unwrap() {
            return this.object;
        }
    }

    public static class WrappedEntity
    extends WrappedItem<Entity> {
        @Deprecated
        public final Entity entity;

        protected WrappedEntity(String wrappingType, Entity entity) {
            super(wrappingType);
            this.entity = (Entity)Preconditions.checkNotNull((Object)entity);
        }

        @Override
        public Entity unwrap() {
            return this.entity;
        }
    }

    public static abstract class WrappedItem<T> {
        @Deprecated
        public final String wrappingType;

        protected WrappedItem(String wrappingType) {
            Preconditions.checkNotNull((Object)wrappingType);
            this.wrappingType = wrappingType;
        }

        public abstract T unwrap();

        public String getWrappingType() {
            return this.wrappingType;
        }

        public String toString() {
            return "Wrapped[" + this.getWrappingType() + ":" + this.unwrap() + "]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.unwrap(), this.getWrappingType()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WrappedItem)) {
                return false;
            }
            return Objects.equal(this.unwrap(), ((WrappedItem)obj).unwrap()) && Objects.equal((Object)this.getWrappingType(), (Object)((WrappedItem)obj).getWrappingType());
        }
    }
}

