/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedStringAttributeSensorAndConfigKey
extends BasicAttributeSensorAndConfigKey<String> {
    private static final long serialVersionUID = 4680651022807491321L;
    public static final Logger LOG = LoggerFactory.getLogger(TemplatedStringAttributeSensorAndConfigKey.class);

    public TemplatedStringAttributeSensorAndConfigKey(String name) {
        this(name, name, null);
    }

    public TemplatedStringAttributeSensorAndConfigKey(String name, String description) {
        this(name, description, null);
    }

    public TemplatedStringAttributeSensorAndConfigKey(String name, String description, String defaultValue) {
        super(String.class, name, description, defaultValue);
    }

    public TemplatedStringAttributeSensorAndConfigKey(TemplatedStringAttributeSensorAndConfigKey orig, String defaultValue) {
        super(orig, defaultValue);
    }

    @Override
    protected String convertConfigToSensor(String value, Entity entity) {
        if (value == null) {
            return null;
        }
        return TemplateProcessor.processTemplateContents("template string sensor " + this.getName(), value, (EntityInternal)entity, (Map<String, ? extends Object>)ImmutableMap.of());
    }

    @Override
    protected String convertConfigToSensor(String value, ManagementContext managementContext) {
        if (value == null) {
            return null;
        }
        return TemplateProcessor.processTemplateContents("template string sensor " + this.getName(), value, managementContext, (Map<String, ? extends Object>)ImmutableMap.of());
    }
}

