/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.stock.AbstractStartableImpl;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStartableImpl
extends AbstractStartableImpl
implements BasicStartable {
    private static final Logger log = LoggerFactory.getLogger(BasicStartableImpl.class);

    @Override
    protected void doStart(Collection<? extends Location> locations) {
        Locations.LocationsFilter filter = (Locations.LocationsFilter)this.getConfig(LOCATIONS_FILTER);
        Iterable<Entity> startables = StartableMethods.filterStartableManagedEntities(this.getChildren());
        if (!Iterables.isEmpty(startables)) {
            ArrayList tasks = Lists.newArrayListWithCapacity((int)Iterables.size(startables));
            for (Entity entity : startables) {
                Collection<? extends Location> l2 = locations;
                if (filter != null) {
                    l2 = filter.filterForContext(new ArrayList<Location>(locations), entity);
                    log.debug("Child " + entity + " of " + this + " being started in filtered location list: " + l2);
                }
                tasks.add(Entities.invokeEffectorWithArgs(this, entity, Startable.START, l2));
            }
            for (Task t : tasks) {
                t.getUnchecked();
            }
        }
    }

    @Override
    protected void doStop() {
        StartableMethods.stop(this);
    }

    @Override
    public void restart() {
        StartableMethods.restart(this);
    }
}

