/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.PluginExecution;

public class Plugin
extends ConfigurationContainer
implements Serializable {
    private String groupId = "org.apache.maven.plugins";
    private String artifactId;
    private String version;
    private boolean extensions = false;
    private List executions;
    private List dependencies;
    private Object goals;
    private Map executionMap = null;
    private String modelEncoding = "UTF-8";
    static /* synthetic */ Class class$org$apache$maven$model$Dependency;
    static /* synthetic */ Class class$org$apache$maven$model$PluginExecution;

    public void addDependency(Dependency dependency) {
        if (!(dependency instanceof Dependency)) {
            throw new ClassCastException("Plugin.addDependencies(dependency) parameter must be instanceof " + (class$org$apache$maven$model$Dependency == null ? (class$org$apache$maven$model$Dependency = Plugin.class$("org.apache.maven.model.Dependency")) : class$org$apache$maven$model$Dependency).getName());
        }
        this.getDependencies().add(dependency);
    }

    public void addExecution(PluginExecution pluginExecution) {
        if (!(pluginExecution instanceof PluginExecution)) {
            throw new ClassCastException("Plugin.addExecutions(pluginExecution) parameter must be instanceof " + (class$org$apache$maven$model$PluginExecution == null ? (class$org$apache$maven$model$PluginExecution = Plugin.class$("org.apache.maven.model.PluginExecution")) : class$org$apache$maven$model$PluginExecution).getName());
        }
        this.getExecutions().add(pluginExecution);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public List getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        return this.dependencies;
    }

    public List getExecutions() {
        if (this.executions == null) {
            this.executions = new ArrayList();
        }
        return this.executions;
    }

    public Object getGoals() {
        return this.goals;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isExtensions() {
        return this.extensions;
    }

    public void removeDependency(Dependency dependency) {
        if (!(dependency instanceof Dependency)) {
            throw new ClassCastException("Plugin.removeDependencies(dependency) parameter must be instanceof " + (class$org$apache$maven$model$Dependency == null ? (class$org$apache$maven$model$Dependency = Plugin.class$("org.apache.maven.model.Dependency")) : class$org$apache$maven$model$Dependency).getName());
        }
        this.getDependencies().remove(dependency);
    }

    public void removeExecution(PluginExecution pluginExecution) {
        if (!(pluginExecution instanceof PluginExecution)) {
            throw new ClassCastException("Plugin.removeExecutions(pluginExecution) parameter must be instanceof " + (class$org$apache$maven$model$PluginExecution == null ? (class$org$apache$maven$model$PluginExecution = Plugin.class$("org.apache.maven.model.PluginExecution")) : class$org$apache$maven$model$PluginExecution).getName());
        }
        this.getExecutions().remove(pluginExecution);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setDependencies(List dependencies) {
        this.dependencies = dependencies;
    }

    public void setExecutions(List executions) {
        this.executions = executions;
    }

    public void setExtensions(boolean extensions) {
        this.extensions = extensions;
    }

    public void setGoals(Object goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void flushExecutionMap() {
        this.executionMap = null;
    }

    public Map getExecutionsAsMap() {
        if (this.executionMap == null) {
            this.executionMap = new HashMap();
            if (this.getExecutions() != null) {
                Iterator i = this.getExecutions().iterator();
                while (i.hasNext()) {
                    PluginExecution exec = (PluginExecution)i.next();
                    if (this.executionMap.containsKey(exec.getId())) {
                        throw new IllegalStateException("You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: '" + exec.getId() + "'\nPlugin:'" + this.getKey() + "'\n\n");
                    }
                    this.executionMap.put(exec.getId(), exec);
                }
            }
        }
        return this.executionMap;
    }

    public String getKey() {
        return Plugin.constructKey(this.groupId, this.artifactId);
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin)other;
            return this.getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Plugin [" + this.getKey() + "]";
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

