/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$AdminClientTopicService$;
import kafka.admin.TopicCommand$ZookeeperTopicService$;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.io.StdIn;
import scala.io.StdIn$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class TopicCommand$
implements Logging {
    public static final TopicCommand$ MODULE$ = new TopicCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.ZookeeperTopicService topicService = opts.zkConnect().isDefined() ? TopicCommand$ZookeeperTopicService$.MODULE$.apply(opts.zkConnect()) : TopicCommand$AdminClientTopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                } else if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                } else if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                } else if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                } else if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    this.printException(e.getCause());
                } else {
                    this.printException(e);
                }
                exitCode = 1;
            }
            catch (Throwable e) {
                this.printException(e);
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
        }
        topicService.close();
        throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
    }

    private void printException(Throwable e) {
        String println_x = new StringBuilder(38).append("Error while executing topic command : ").append(e.getMessage()).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var2_2 = null;
        if (this.logger().underlying().isErrorEnabled()) {
            String string;
            String string2 = string = Utils.stackTrace((Throwable)e);
            string = null;
            String msgWithLogIdent_msg = string2;
            Object var3_4 = null;
            this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> foundTopics, Option<String> requestedTopic, boolean requireTopicExists) {
        if (requestedTopic.isDefined() && requireTopicExists && foundTopics.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Topic '").append(requestedTopic.get()).append("' does not exist as expected").toString());
        }
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicIncludeList, boolean excludeInternalTopics) {
        if (topicIncludeList.isDefined()) {
            IncludeList topicsFilter = new IncludeList((String)topicIncludeList.get());
            return (Seq)allTopics.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)topicsFilter.isTopicAllowed(x$16, excludeInternalTopics)));
        }
        return (Seq)allTopics.filterNot((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$doGetTopics$2(excludeInternalTopics, x$17)));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_6;
        java.util.List list;
        Option<java.util.List<String>> option = opts.topicConfig();
        if (option == null) {
            throw null;
        }
        Option<java.util.List<String>> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            java.util.List list2;
            java.util.List list3 = list2 = Collections.emptyList();
            list2 = null;
            list = list3;
        } else {
            list = getOrElse_this.get();
        }
        java.util.List list4 = list;
        Object var4_2 = null;
        list = null;
        Buffer configsToBeAdded = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, list4).asScala().map((Function1 & Serializable)x$18 -> x$18.split("\\s*=\\s*"));
        if (!configsToBeAdded.forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config)))) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Invalid topic config: all configs to be added must be in the format \"key=val\".").toString());
        }
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1 & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            String println_x = new StringBuilder(0).append(new StringBuilder(43).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").toString()).append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString();
            Console$.MODULE$.println((Object)println_x);
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_5;
        java.util.List list;
        Option<java.util.List<String>> option = opts.configsToDelete();
        if (option == null) {
            throw null;
        }
        Option<java.util.List<String>> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            java.util.List list2;
            java.util.List list3 = list2 = Collections.emptyList();
            list2 = null;
            list = list3;
        } else {
            list = getOrElse_this.get();
        }
        java.util.List list4 = list;
        Object var4_2 = null;
        list = null;
        Buffer configsToBeDeleted = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, list4).asScala().map((Function1 & Serializable)x$19 -> x$19.trim());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1 & Serializable)x$20 -> propsToBeDeleted.setProperty((String)x$20, ""));
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        int n = 0;
        int n2 = partitionList.length;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, n2, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TopicCommand$.$anonfun$parseReplicaAssignment$1(partitionList, ret, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return var3_3;
    }

    public java.util.Map<Integer, java.util.List<Integer>> asJavaReplicaReassignment(Map<Object, List<Object>> original) {
        return AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)original.map((Function1 & Serializable)f -> {
            Nil$ nil$;
            Integer n = f._1$mcI$sp();
            List list = (List)f._2();
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_this == Nil$.MODULE$) {
                nil$ = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_this.head()), (List)Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                    map_t.next_$eq((List)map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                nil$ = map_h;
            }
            Nil$ nil$2 = nil$;
            Object var3_1 = null;
            Object var4_3 = null;
            Object var5_4 = null;
            Object var6_5 = null;
            Object var7_6 = null;
            nil$ = null;
            java.util.List $minus$greater$extension_y = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)nil$2).asJava();
            Integer $minus$greater$extension_$this = n;
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }))).asJava();
    }

    public int kafka$admin$TopicCommand$$getReplicationFactor(TopicPartitionInfo tpi, Option<PartitionReassignment> reassignment) {
        int n;
        PartitionReassignment ra;
        if (reassignment instanceof Some && TopicCommand$.isReassignmentInProgress$1(ra = (PartitionReassignment)((Some)reassignment).value(), tpi)) {
            SeqOps seqOps = (SeqOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ra.replicas()).asScala().diff((Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ra.addingReplicas()).asScala());
            if (seqOps == null) {
                throw null;
            }
            SeqOps size_this = seqOps;
            Object var5_4 = null;
            n = size_this.length();
        } else {
            n = tpi.replicas().size();
        }
        return n;
    }

    public void askToProceed() {
        String println_x = "Are you sure you want to continue? [y/n]";
        Console$.MODULE$.println((Object)println_x);
        Object var1_1 = null;
        if (!StdIn.readLine$((StdIn)StdIn$.MODULE$).equalsIgnoreCase("y")) {
            String println_x2 = "Ending your session";
            Console$.MODULE$.println((Object)println_x2);
            Object var2_2 = null;
            throw Exit$.MODULE$.exit(0, (Option<String>)None$.MODULE$);
        }
    }

    public static final /* synthetic */ String $anonfun$printException$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ boolean $anonfun$doGetTopics$2(boolean excludeInternalTopics$1, String x$17) {
        return Topic.isInternal((String)x$17) && excludeInternalTopics$1;
    }

    public static final /* synthetic */ java.util.List $anonfun$parseTopicConfigsToBeAdded$1() {
        return Collections.emptyList();
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseTopicConfigsToBeAdded$4() {
        return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ java.util.List $anonfun$parseTopicConfigsToBeDeleted$1() {
        return Collections.emptyList();
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String s) {
        return Integer.parseInt(s.trim());
    }

    public static final /* synthetic */ void $anonfun$parseReplicaAssignment$1(String[] partitionList$1, LinkedHashMap ret$1, int i) {
        Object var7_7;
        int[] nArray;
        int[] nArray2;
        String[] map$extension_$this = partitionList$1[i].split(":");
        int n = map$extension_$this.length;
        int[] nArray3 = nArray2 = new int[n];
        nArray2 = null;
        int[] nArray4 = nArray = nArray3;
        nArray = null;
        int[] map$extension_ys = nArray4;
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                int n2;
                map$extension_ys[map$extension_i] = n2 = TopicCommand$.$anonfun$parseReplicaAssignment$2(map$extension_$this[map$extension_i]);
            }
        }
        void v2 = var7_7;
        Object var6_3 = null;
        var7_7 = null;
        void brokerList = v2;
        Iterable duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray((int[])brokerList));
        if (duplicateBrokers.nonEmpty()) {
            String mkString_sep = ",";
            Object var5_12 = null;
            throw new AdminCommandFailedException(new StringBuilder(59).append("Partition replica lists may not contain duplicate entries: ").append(duplicateBrokers.mkString("", mkString_sep, "")).toString());
        }
        ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray((int[])brokerList);
        if (ofInt2 == null) {
            throw null;
        }
        ret$1.put((Object)i, (Object)IterableOnceOps.toList$((IterableOnceOps)ofInt2));
        SeqOps seqOps = (SeqOps)ret$1.apply((Object)i);
        if (seqOps == null) {
            throw null;
        }
        SeqOps seqOps2 = (SeqOps)ret$1.apply((Object)0);
        if (seqOps2 == null) {
            throw null;
        }
        if (seqOps.length() != seqOps2.length()) {
            throw new AdminOperationException(new StringBuilder(45).append("Partition ").append(i).append(" has different replication factor: ").append(brokerList).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isReassignmentInProgress$1(PartitionReassignment ra, TopicPartitionInfo tpi$1) {
        void $plus$plus_that;
        Set allReplicaIds = ((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)tpi$1.replicas()).asScala().map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.id()))).toSet();
        Set set = ((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ra.removingReplicas()).asScala().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22))).toSet();
        Set set2 = ((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ra.addingReplicas()).asScala().map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToInteger((int)x$23))).toSet();
        if (set == null) {
            throw null;
        }
        set2 = null;
        Set changingReplicaIds = (Set)set.concat((IterableOnce)$plus$plus_that);
        return allReplicaIds.exists((Function1)(JFunction1.mcZI.sp & Serializable)elem -> changingReplicaIds.contains((Object)BoxesRunTime.boxToInteger((int)elem)));
    }

    private TopicCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$parseReplicaAssignment$2$adapted(String s) {
        return BoxesRunTime.boxToInteger((int)TopicCommand$.$anonfun$parseReplicaAssignment$2(s));
    }

    public static final /* synthetic */ Integer $anonfun$asJavaReplicaReassignment$2$adapted(Object e) {
        return BoxesRunTime.unboxToInt((Object)e);
    }
}

