/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.oss.credential;

import com.aliyun.credentials.Client;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialGenerator;
import org.apache.gravitino.credential.OSSTokenCredential;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.credential.config.OSSCredentialConfig;
import org.apache.gravitino.oss.credential.policy.Condition;
import org.apache.gravitino.oss.credential.policy.Policy;
import org.apache.gravitino.oss.credential.policy.Statement;
import org.apache.gravitino.oss.credential.policy.StringLike;

public class OSSTokenGenerator
implements CredentialGenerator<OSSTokenCredential> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String accessKeyId;
    private String secretAccessKey;
    private String roleArn;
    private String externalID;
    private int tokenExpireSecs;
    private String region;

    public void initialize(Map<String, String> properties) {
        OSSCredentialConfig credentialConfig = new OSSCredentialConfig(properties);
        this.roleArn = credentialConfig.ossRoleArn();
        this.externalID = credentialConfig.externalID();
        this.tokenExpireSecs = credentialConfig.tokenExpireInSecs();
        this.accessKeyId = credentialConfig.accessKeyID();
        this.secretAccessKey = credentialConfig.secretAccessKey();
        this.region = credentialConfig.region();
    }

    public OSSTokenCredential generate(CredentialContext context) throws Exception {
        if (!(context instanceof PathBasedCredentialContext)) {
            return null;
        }
        PathBasedCredentialContext pathContext = (PathBasedCredentialContext)context;
        CredentialModel credentialModel = this.createOSSCredentialModel(pathContext.getReadPaths(), pathContext.getWritePaths(), pathContext.getUserName());
        return new OSSTokenCredential(credentialModel.accessKeyId, credentialModel.accessKeySecret, credentialModel.securityToken, credentialModel.expiration);
    }

    private CredentialModel createOSSCredentialModel(Set<String> readLocations, Set<String> writeLocations, String userName) {
        Config config = new Config();
        config.setAccessKeyId(this.accessKeyId);
        config.setAccessKeySecret(this.secretAccessKey);
        config.setType("ram_role_arn");
        config.setRoleArn(this.roleArn);
        config.setRoleSessionName(this.getRoleName(userName));
        if (StringUtils.isNotBlank((CharSequence)this.externalID)) {
            config.setExternalId(this.externalID);
        }
        config.setRoleSessionExpiration(Integer.valueOf(this.tokenExpireSecs));
        config.setPolicy(this.createPolicy(readLocations, writeLocations, this.region));
        Client client = new Client(config);
        return client.getCredential();
    }

    private String createPolicy(Set<String> readLocations, Set<String> writeLocations, String region) {
        Policy.Builder policyBuilder = Policy.builder().version("1");
        Statement.Builder allowGetObjectStatementBuilder = Statement.builder().effect("Allow").addAction("oss:GetObject").addAction("oss:GetObjectVersion");
        HashMap bucketListStatementBuilder = new HashMap();
        HashMap bucketMetadataStatementBuilder = new HashMap();
        String arnPrefix = this.getArnPrefix(region);
        Stream.concat(readLocations.stream(), writeLocations.stream()).distinct().forEach(location -> {
            URI uri = URI.create(location);
            allowGetObjectStatementBuilder.addResource(this.getOssUriWithArn(arnPrefix, uri));
            String bucketArn = arnPrefix + this.getBucketName(uri);
            bucketListStatementBuilder.computeIfAbsent(bucketArn, key -> Statement.builder().effect("Allow").addAction("oss:ListObjects").addResource((String)key).condition(this.getCondition(uri)));
            bucketMetadataStatementBuilder.computeIfAbsent(bucketArn, key -> Statement.builder().effect("Allow").addAction("oss:GetBucketLocation").addAction("oss:GetBucketInfo").addResource((String)key));
        });
        if (!writeLocations.isEmpty()) {
            Statement.Builder allowPutObjectStatementBuilder = Statement.builder().effect("Allow").addAction("oss:PutObject").addAction("oss:DeleteObject");
            writeLocations.forEach(location -> {
                URI uri = URI.create(location);
                allowPutObjectStatementBuilder.addResource(this.getOssUriWithArn(arnPrefix, uri));
            });
            policyBuilder.addStatement(allowPutObjectStatementBuilder.build());
        }
        if (!bucketListStatementBuilder.isEmpty()) {
            bucketListStatementBuilder.values().forEach(statementBuilder -> policyBuilder.addStatement(statementBuilder.build()));
        } else {
            policyBuilder.addStatement(Statement.builder().effect("Allow").addAction("oss:ListBucket").build());
        }
        bucketMetadataStatementBuilder.values().forEach(statementBuilder -> policyBuilder.addStatement(statementBuilder.build()));
        policyBuilder.addStatement(allowGetObjectStatementBuilder.build());
        try {
            return this.objectMapper.writeValueAsString((Object)policyBuilder.build());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Condition getCondition(URI uri) {
        return Condition.builder().stringLike(StringLike.builder().addPrefix(OSSTokenGenerator.concatPathWithSep(this.trimLeadingSlash(uri.getPath()), "*", "/")).build()).build();
    }

    private String getArnPrefix(String region) {
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            return "acs:oss:" + region + ":*:";
        }
        return "acs:oss:*:*:";
    }

    private String getBucketName(URI uri) {
        return uri.getHost();
    }

    private String getOssUriWithArn(String arnPrefix, URI uri) {
        return arnPrefix + OSSTokenGenerator.concatPathWithSep(this.removeSchemaFromOSSUri(uri), "*", "/");
    }

    private static String concatPathWithSep(String leftPath, String rightPath, String fileSep) {
        if (leftPath.endsWith(fileSep) && rightPath.startsWith(fileSep)) {
            return leftPath + rightPath.substring(1);
        }
        if (!leftPath.endsWith(fileSep) && !rightPath.startsWith(fileSep)) {
            return leftPath + fileSep + rightPath;
        }
        return leftPath + rightPath;
    }

    private String removeSchemaFromOSSUri(URI uri) {
        String bucket = uri.getHost();
        String path = this.trimLeadingSlash(uri.getPath());
        return String.join((CharSequence)"/", (CharSequence[])Stream.of(bucket, path).filter(Objects::nonNull).toArray(String[]::new));
    }

    private String trimLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private String getRoleName(String userName) {
        return "gravitino_" + userName;
    }

    public void close() throws IOException {
    }
}

