/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.casbin.jcasbin.rbac.LinkConditionFuncKey;

class Role {
    private final String name;
    final Map<String, Role> roles;
    private final Map<String, Role> users;
    private final Map<String, Role> matched;
    private final Map<String, Role> matchedBy;
    private final Map<LinkConditionFuncKey, Function<String[], Boolean>> linkConditionFuncMap;
    private final Map<LinkConditionFuncKey, String[]> linkConditionFuncParamsMap;

    protected Role(String name) {
        this.name = name;
        this.roles = new HashMap<String, Role>();
        this.users = new HashMap<String, Role>();
        this.matched = new HashMap<String, Role>();
        this.matchedBy = new HashMap<String, Role>();
        this.linkConditionFuncMap = new HashMap<LinkConditionFuncKey, Function<String[], Boolean>>();
        this.linkConditionFuncParamsMap = new HashMap<LinkConditionFuncKey, String[]>();
    }

    String getName() {
        return this.name;
    }

    void addRole(Role role) {
        this.roles.put(role.name, role);
        role.addUser(this);
    }

    void removeRole(Role role) {
        this.roles.remove(role.name);
        role.removeUser(this);
    }

    private void addUser(Role user) {
        this.users.put(user.name, user);
    }

    private void removeUser(Role user) {
        this.users.remove(user.name);
    }

    void addMatch(Role role) {
        this.matched.put(role.name, role);
        role.matchedBy.put(this.name, this);
    }

    void removeMatch(Role role) {
        this.matched.remove(role.name);
        role.matchedBy.remove(this.name);
    }

    void removeMatches() {
        Iterator<Map.Entry<String, Role>> iterator = this.matchedBy.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Role> entry = iterator.next();
            Role role = entry.getValue();
            role.matched.remove(this.name);
            iterator.remove();
        }
    }

    public void rangeRoles(Consumer<? super Role> fn) {
        this.roles.forEach((key, value) -> {
            Role role = value;
            fn.accept(role);
            role.matched.forEach((matchedKey, matchedValue) -> {
                Role matchedRole = matchedValue;
                fn.accept(matchedRole);
            });
        });
        this.matchedBy.forEach((key, value) -> {
            Role role = value;
            role.roles.forEach((roleKey, roleValue) -> {
                Role subRole = roleValue;
                fn.accept(subRole);
            });
        });
    }

    public String toString() {
        List<String> roles = this.getRoles();
        if (roles.size() == 0) {
            return "";
        }
        StringBuilder names = new StringBuilder();
        names.append(this.name).append(" < ");
        if (roles.size() != 1) {
            names.append("(");
        }
        for (int i = 0; i < roles.size(); ++i) {
            String role = roles.get(i);
            if (i == 0) {
                names.append(role);
                continue;
            }
            names.append(", ").append(role);
        }
        if (roles.size() != 1) {
            names.append(")");
        }
        return names.toString();
    }

    List<String> getRoles() {
        return new ArrayList<String>(this.getAllRoles().keySet());
    }

    List<String> getUsers() {
        return new ArrayList<String>(this.getAllUsers().keySet());
    }

    Map<String, Role> getAllRoles() {
        HashMap<String, Role> allRoles = new HashMap<String, Role>(this.roles);
        this.roles.values().forEach(role -> allRoles.putAll(role.matched));
        this.matchedBy.values().forEach(role -> allRoles.putAll(role.roles));
        return allRoles;
    }

    Map<String, Role> getAllUsers() {
        HashMap<String, Role> allUsers = new HashMap<String, Role>(this.users);
        this.users.values().forEach(role -> allUsers.putAll(role.matched));
        this.matchedBy.values().forEach(role -> allUsers.putAll(role.users));
        return allUsers;
    }

    void addLinkConditionFunc(Role role, String domain, Function<String[], Boolean> fn) {
        this.linkConditionFuncMap.put(new LinkConditionFuncKey(role.name, domain), fn);
    }

    Function<String[], Boolean> getLinkConditionFunc(Role role, String domain) {
        Function<String[], Boolean> function = this.linkConditionFuncMap.get(new LinkConditionFuncKey(role.name, domain));
        if (function == null) {
            return null;
        }
        return this.linkConditionFuncMap.get(new LinkConditionFuncKey(role.name, domain));
    }

    void setLinkConditionFuncParams(Role role, String domain, String ... params) {
        this.linkConditionFuncParamsMap.put(new LinkConditionFuncKey(role.name, domain), params);
    }

    String[] getLinkConditionFuncParams(Role role, String domain) {
        return this.linkConditionFuncParamsMap.get(new LinkConditionFuncKey(role.name, domain));
    }
}

