/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.utils;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] generateIpcStream(Schema arrowSchema) throws IOException {
        try (RootAllocator allocator = new RootAllocator();){
            byte[] byArray;
            block19: {
                VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);
                try {
                    root.allocateNew();
                    root.setRowCount(0);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, Channels.newChannel(outputStream));){
                        writer.start();
                        writer.writeBatch();
                        writer.end();
                    }
                    byArray = outputStream.toByteArray();
                    if (root == null) break block19;
                }
                catch (Throwable throwable) {
                    if (root != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                root.close();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new IOException("Failed to create empty Arrow IPC stream: " + e.getMessage(), e);
        }
    }

    public static Schema parseArrowIpcStream(byte[] stream) {
        Schema schema;
        try (RootAllocator allocator = new RootAllocator();
             ByteArrayInputStream bais = new ByteArrayInputStream(stream);
             ArrowStreamReader reader = new ArrowStreamReader((InputStream)bais, (BufferAllocator)allocator);){
            schema = reader.getVectorSchemaRoot().getSchema();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse Arrow IPC stream", e);
        }
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"No schema found in Arrow IPC stream");
        return schema;
    }
}

