/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.Renderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

final class RedocConfig
extends AbstractViewConfig
implements Renderer {
    private static final Map<String, Object> DEFAULT_OPTIONS = Collections.emptyMap();
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(24);
    RapiPDFConfig rapiPDFConfig;

    private RedocConfig() {
        super("redoc.");
    }

    static RedocConfig fromProperties(Map<String, String> properties) {
        return AbstractViewConfig.fromProperties(new RedocConfig(), DEFAULT_OPTIONS, properties);
    }

    @Override
    public String render(String template) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.REDOC);
        template = OpenApiViewConfig.replacePlaceHolder(template, "redoc.version", this.version, "@");
        return OpenApiViewConfig.replacePlaceHolder(template, "redoc.attributes", this.toHtmlAttributes(), "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    static {
        VALID_OPTIONS.put("disable-search", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("expand-default-server-variables", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("expand-responses", AbstractViewConfig::asString);
        VALID_OPTIONS.put("hide-download-button", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-hostname", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-loading", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-schema-titles", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-single-request-sample-tab", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("expand-single-schema-field", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("json-sample-expand-level", AbstractViewConfig::asString);
        VALID_OPTIONS.put("menu-toggle", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("native-scrollbars", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("no-auto-auth", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("only-required-in-samples", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("path-in-middle-panel", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("required-props-first", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("scroll-y-offset", AbstractViewConfig::asString);
        VALID_OPTIONS.put("simple-one-of-type-label", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("show-extensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("sort-props-alphabetically", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("suppress-warnings", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("payload-sample-idx", AbstractViewConfig::asString);
        VALID_OPTIONS.put("theme", AbstractViewConfig::asString);
        VALID_OPTIONS.put("untrusted-spec", AbstractViewConfig::asBoolean);
    }
}

