/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.marshaller.BinaryMode;

public class MarshallerUtil {
    public static BinaryMode mode(Class<?> cls) {
        assert (cls != null);
        if (cls == Byte.TYPE) {
            return BinaryMode.P_BYTE;
        }
        if (cls == Short.TYPE) {
            return BinaryMode.P_SHORT;
        }
        if (cls == Integer.TYPE) {
            return BinaryMode.P_INT;
        }
        if (cls == Long.TYPE) {
            return BinaryMode.P_LONG;
        }
        if (cls == Float.TYPE) {
            return BinaryMode.P_FLOAT;
        }
        if (cls == Double.TYPE) {
            return BinaryMode.P_DOUBLE;
        }
        if (cls == Byte.class) {
            return BinaryMode.BYTE;
        }
        if (cls == Short.class) {
            return BinaryMode.SHORT;
        }
        if (cls == Integer.class) {
            return BinaryMode.INT;
        }
        if (cls == Long.class) {
            return BinaryMode.LONG;
        }
        if (cls == Float.class) {
            return BinaryMode.FLOAT;
        }
        if (cls == Double.class) {
            return BinaryMode.DOUBLE;
        }
        if (cls == LocalDate.class) {
            return BinaryMode.DATE;
        }
        if (cls == LocalTime.class) {
            return BinaryMode.TIME;
        }
        if (cls == LocalDateTime.class) {
            return BinaryMode.DATETIME;
        }
        if (cls == Instant.class) {
            return BinaryMode.TIMESTAMP;
        }
        if (cls == byte[].class) {
            return BinaryMode.BYTE_ARR;
        }
        if (cls == String.class) {
            return BinaryMode.STRING;
        }
        if (cls == UUID.class) {
            return BinaryMode.UUID;
        }
        if (cls == BitSet.class) {
            return BinaryMode.BITSET;
        }
        if (cls == BigInteger.class) {
            return BinaryMode.NUMBER;
        }
        if (cls == BigDecimal.class) {
            return BinaryMode.DECIMAL;
        }
        return null;
    }

    private MarshallerUtil() {
    }
}

