/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.schema.configuration.storage.DataStorageConfigurationSchema;
import org.apache.ignite.internal.schema.configuration.storage.UnknownDataStorageConfigurationSchema;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.jetbrains.annotations.Nullable;

public class DataStorageModules {
    private final Map<String, DataStorageModule> modules;

    public DataStorageModules(Iterable<DataStorageModule> dataStorageModules) {
        HashMap<String, DataStorageModule> modules = new HashMap<String, DataStorageModule>();
        for (DataStorageModule module : dataStorageModules) {
            String name = module.name();
            if (modules.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate name [name=%s, factories=%s]", name, List.of((DataStorageModule)modules.get(name), module)));
            }
            if (name.equals("unknown")) {
                throw new IllegalStateException(String.format("Invalid name [name=%s, factory=%s]", name, module));
            }
            modules.put(name, module);
        }
        assert (!modules.isEmpty());
        this.modules = modules;
    }

    public Map<String, StorageEngine> createStorageEngines(String igniteInstanceName, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector) {
        return this.modules.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((DataStorageModule)e.getValue()).createEngine(igniteInstanceName, configRegistry, storagePath, longJvmPauseDetector)));
    }

    public Map<String, Map<String, Class<?>>> collectSchemasFields(Collection<Class<?>> polymorphicSchemaExtensions) {
        Map<String, Class<? extends DataStorageConfigurationSchema>> schemas = polymorphicSchemaExtensions.stream().filter(DataStorageConfigurationSchema.class::isAssignableFrom).filter(Predicate.not(UnknownDataStorageConfigurationSchema.class::isAssignableFrom)).collect(Collectors.toUnmodifiableMap(schemaCls -> DataStorageModules.schemaName(schemaCls), schemaCls -> schemaCls));
        DataStorageModules.checkSchemas(this.modules, schemas);
        return this.modules.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> this.schemaValueFields((Class)schemas.get(e.getKey()))));
    }

    private Map<String, Class<?>> schemaValueFields(Class<? extends DataStorageConfigurationSchema> dataStorageSchema) {
        return Stream.of(dataStorageSchema.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Value.class)).collect(Collectors.toUnmodifiableMap(Field::getName, Field::getType));
    }

    private static String schemaName(Class<? extends DataStorageConfigurationSchema> dataStorageSchema) {
        PolymorphicConfigInstance polymorphicConfigInstance = dataStorageSchema.getAnnotation(PolymorphicConfigInstance.class);
        assert (polymorphicConfigInstance != null) : dataStorageSchema;
        return polymorphicConfigInstance.value();
    }

    private static void checkSchemas(Map<String, DataStorageModule> modules, Map<String, Class<? extends DataStorageConfigurationSchema>> schemas) {
        if (!modules.keySet().equals(schemas.keySet())) {
            List dataStorageWithoutSchema = modules.keySet().stream().filter(Predicate.not(schemas::containsKey)).collect(Collectors.toList());
            if (!dataStorageWithoutSchema.isEmpty()) {
                throw new IllegalStateException("Missing configuration schemas (DataStorageConfigurationSchema heir) for data storage engines: " + dataStorageWithoutSchema);
            }
            List schemasWithoutDataStorages = schemas.entrySet().stream().filter(e -> !modules.containsKey(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            if (!schemasWithoutDataStorages.isEmpty()) {
                throw new IllegalStateException("Missing data storage engines for schemas: " + schemasWithoutDataStorages);
            }
        }
    }
}

