/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.TimeChunkWriter;
import org.apache.iotdb.tsfile.write.chunk.ValueChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class AlignedChunkWriterImpl
implements IChunkWriter {
    private final TimeChunkWriter timeChunkWriter;
    private final List<ValueChunkWriter> valueChunkWriterList;
    private int valueIndex;

    public AlignedChunkWriterImpl(VectorMeasurementSchema schema) {
        this.timeChunkWriter = new TimeChunkWriter(schema.getMeasurementId(), schema.getCompressor(), schema.getTimeTSEncoding(), schema.getTimeEncoder());
        List<String> valueMeasurementIdList = schema.getSubMeasurementsList();
        List<TSDataType> valueTSDataTypeList = schema.getSubMeasurementsTSDataTypeList();
        List<TSEncoding> valueTSEncodingList = schema.getSubMeasurementsTSEncodingList();
        List<Encoder> valueEncoderList = schema.getSubMeasurementsEncoderList();
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(valueMeasurementIdList.size());
        for (int i = 0; i < valueMeasurementIdList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueMeasurementIdList.get(i), schema.getCompressor(), valueTSDataTypeList.get(i), valueTSEncodingList.get(i), valueEncoderList.get(i)));
        }
        this.valueIndex = 0;
    }

    public AlignedChunkWriterImpl(List<IMeasurementSchema> schemaList) {
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        this.timeChunkWriter = new TimeChunkWriter("", schemaList.get(0).getCompressor(), timeEncoding, TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType));
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(schemaList.size());
        for (int i = 0; i < schemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(schemaList.get(i).getMeasurementId(), schemaList.get(i).getCompressor(), schemaList.get(i).getType(), schemaList.get(i).getEncodingType(), schemaList.get(i).getValueEncoder()));
        }
        this.valueIndex = 0;
    }

    public void write(long time, int value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, long value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, boolean value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, float value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, double value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, Binary value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, TsPrimitiveType[] points) {
        this.valueIndex = 0;
        block8: for (TsPrimitiveType point : points) {
            ValueChunkWriter writer = this.valueChunkWriterList.get(this.valueIndex++);
            switch (writer.getDataType()) {
                case INT64: {
                    writer.write(time, point != null ? point.getLong() : Long.MAX_VALUE, point == null);
                    continue block8;
                }
                case INT32: {
                    writer.write(time, point != null ? point.getInt() : Integer.MAX_VALUE, point == null);
                    continue block8;
                }
                case FLOAT: {
                    writer.write(time, point != null ? point.getFloat() : Float.MAX_VALUE, point == null);
                    continue block8;
                }
                case DOUBLE: {
                    writer.write(time, point != null ? point.getDouble() : Double.MAX_VALUE, point == null);
                    continue block8;
                }
                case BOOLEAN: {
                    writer.write(time, point != null ? point.getBoolean() : false, point == null);
                    continue block8;
                }
                case TEXT: {
                    writer.write(time, point != null ? point.getBinary() : new Binary("".getBytes(StandardCharsets.UTF_8)), point == null);
                }
            }
        }
        this.write(time);
    }

    public void write(long time) {
        this.valueIndex = 0;
        this.timeChunkWriter.write(time);
        if (this.checkPageSizeAndMayOpenANewPage()) {
            this.writePageToPageBuffer();
        }
    }

    private boolean checkPageSizeAndMayOpenANewPage() {
        if (this.timeChunkWriter.checkPageSizeAndMayOpenANewPage()) {
            return true;
        }
        for (ValueChunkWriter writer : this.valueChunkWriterList) {
            if (!writer.checkPageSizeAndMayOpenANewPage()) continue;
            return true;
        }
        return false;
    }

    private void writePageToPageBuffer() {
        this.timeChunkWriter.writePageToPageBuffer();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.writePageToPageBuffer();
        }
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.timeChunkWriter.writeToFileWriter(tsfileWriter);
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.writeToFileWriter(tsfileWriter);
        }
    }

    @Override
    public long estimateMaxSeriesMemSize() {
        long estimateMaxSeriesMemSize = this.timeChunkWriter.estimateMaxSeriesMemSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            estimateMaxSeriesMemSize += valueChunkWriter.estimateMaxSeriesMemSize();
        }
        return estimateMaxSeriesMemSize;
    }

    @Override
    public long getSerializedChunkSize() {
        long currentChunkSize = this.timeChunkWriter.getCurrentChunkSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            currentChunkSize += valueChunkWriter.getCurrentChunkSize();
        }
        return currentChunkSize;
    }

    @Override
    public void sealCurrentPage() {
        this.timeChunkWriter.sealCurrentPage();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.sealCurrentPage();
        }
    }

    @Override
    public void clearPageWriter() {
        this.timeChunkWriter.clearPageWriter();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.clearPageWriter();
        }
    }

    public boolean checkIsChunkSizeOverThreshold(long threshold) {
        if (this.timeChunkWriter.estimateMaxSeriesMemSize() > threshold) {
            return true;
        }
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            if (valueChunkWriter.estimateMaxSeriesMemSize() <= threshold) continue;
            return true;
        }
        return false;
    }

    public TSDataType getCurrentValueChunkType() {
        return this.valueChunkWriterList.get(this.valueIndex).getDataType();
    }

    public ValueChunkWriter getValueChunkWriterByIndex(int valueIndex) {
        return this.valueChunkWriterList.get(valueIndex);
    }
}

