/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.json.bind.JsonbException;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbDateFormat;
import javax.json.bind.annotation.JsonbNillable;
import javax.json.bind.annotation.JsonbNumberFormat;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbPropertyOrder;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.bind.annotation.JsonbTypeAdapter;
import javax.json.bind.annotation.JsonbTypeDeserializer;
import javax.json.bind.annotation.JsonbTypeSerializer;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.jsonb.converter.JohnzonJsonbAdapter;
import org.apache.johnzon.jsonb.converter.JsonbDateConverter;
import org.apache.johnzon.jsonb.converter.JsonbLocalDateConverter;
import org.apache.johnzon.jsonb.converter.JsonbLocalDateTimeConverter;
import org.apache.johnzon.jsonb.converter.JsonbNumberConverter;
import org.apache.johnzon.jsonb.converter.JsonbValueConverter;
import org.apache.johnzon.jsonb.converter.JsonbZonedDateTimeConverter;
import org.apache.johnzon.jsonb.serializer.JohnzonDeserializationContext;
import org.apache.johnzon.jsonb.serializer.JohnzonSerializationContext;
import org.apache.johnzon.jsonb.spi.JohnzonAdapterFactory;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonAny;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.MapperConverter;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.FieldAccessMode;
import org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.apache.johnzon.mapper.access.Meta;
import org.apache.johnzon.mapper.access.MethodAccessMode;
import org.apache.johnzon.mapper.converter.ReversedAdapter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.Converters;

public class JsonbAccessMode
implements AccessMode,
Closeable {
    private final PropertyNamingStrategy naming;
    private final String order;
    private final PropertyVisibilityStrategy visibility;
    private final AccessMode delegate;
    private final boolean caseSensitive;
    private final Map<AdapterKey, Adapter<?, ?>> defaultConverters;
    private final JohnzonAdapterFactory factory;
    private final Collection<JohnzonAdapterFactory.Instance<?>> toRelease = new ArrayList();
    private final Supplier<JsonParserFactory> parserFactory;
    private final ConcurrentMap<Class<?>, ParsingCacheEntry> parsingCache = new ConcurrentHashMap();
    private final BaseAccessMode partialDelegate = new BaseAccessMode(false, false){

        protected Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
            throw new UnsupportedOperationException();
        }

        protected Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
            throw new UnsupportedOperationException();
        }
    };

    public JsonbAccessMode(PropertyNamingStrategy propertyNamingStrategy, String orderValue, PropertyVisibilityStrategy visibilityStrategy, boolean caseSensitive, Map<AdapterKey, Adapter<?, ?>> defaultConverters, JohnzonAdapterFactory factory, Supplier<JsonParserFactory> parserFactory, AccessMode delegate) {
        this.naming = propertyNamingStrategy;
        this.order = orderValue;
        this.visibility = visibilityStrategy;
        this.caseSensitive = caseSensitive;
        this.delegate = delegate;
        this.defaultConverters = defaultConverters;
        this.factory = factory;
        this.parserFactory = parserFactory;
    }

    public Comparator<String> fieldComparator(Class<?> clazz) {
        Comparator orderComparator = this.orderComparator(clazz);
        return this.caseSensitive ? orderComparator : (o1, o2) -> o1.equalsIgnoreCase((String)o2) ? 0 : orderComparator.compare(o1, o2);
    }

    /*
     * WARNING - void declaration
     */
    public AccessMode.Factory findFactory(final Class<?> clazz) {
        void var7_14;
        ObjectConverter.Codec[] objectConverters;
        Adapter[] itemConverters;
        Adapter[] converters;
        Type[] types;
        Constructor<?> constructor = null;
        Executable factory = null;
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            if (!constructor2.isAnnotationPresent(JsonbCreator.class)) continue;
            if (constructor != null) {
                throw new IllegalArgumentException("Only one constructor or method can have @JsonbCreator");
            }
            constructor = constructor2;
        }
        for (Executable executable : clazz.getMethods()) {
            int modifiers = ((Method)executable).getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !executable.isAnnotationPresent(JsonbCreator.class)) continue;
            if (constructor != null || factory != null) {
                throw new IllegalArgumentException("Only one constructor or method can have @JsonbCreator");
            }
            factory = executable;
        }
        final Constructor<?> finalConstructor = constructor;
        final Method finalFactory = factory;
        if (finalConstructor != null || finalFactory != null) {
            types = finalConstructor != null ? finalConstructor.getGenericParameterTypes() : finalFactory.getGenericParameterTypes();
            String[] stringArray = new String[types.length];
            converters = new Adapter[types.length];
            itemConverters = new Adapter[types.length];
            objectConverters = new ObjectConverter.Codec[types.length];
            int i = 0;
            for (Parameter parameter : (finalConstructor == null ? finalFactory : finalConstructor).getParameters()) {
                JsonbProperty property = JsonbAccessMode.getAnnotation(parameter, JsonbProperty.class);
                stringArray[i] = property != null ? property.value() : parameter.getName();
                JsonbTypeAdapter adapter = JsonbAccessMode.getAnnotation(parameter, JsonbTypeAdapter.class);
                JsonbDateFormat dateFormat = JsonbAccessMode.getAnnotation(parameter, JsonbDateFormat.class);
                JsonbNumberFormat numberFormat = JsonbAccessMode.getAnnotation(parameter, JsonbNumberFormat.class);
                JohnzonConverter johnzonConverter = JsonbAccessMode.getAnnotation(parameter, JohnzonConverter.class);
                if (adapter == null && dateFormat == null && numberFormat == null && johnzonConverter == null) {
                    converters[i] = this.defaultConverters.get(parameter.getType());
                    itemConverters[i] = null;
                } else {
                    this.validateAnnotations(parameter, adapter, dateFormat, numberFormat, johnzonConverter);
                    try {
                        if (adapter != null) {
                            Adapter<?, ?> converter = this.toConverter(parameter.getType(), adapter, dateFormat, numberFormat);
                            if (Converters.matches((Type)parameter.getParameterizedType(), converter)) {
                                converters[i] = converter;
                                itemConverters[i] = null;
                            } else {
                                converters[i] = null;
                                itemConverters[i] = converter;
                            }
                        } else if (johnzonConverter != null) {
                            objectConverters[i] = (ObjectConverter.Codec)johnzonConverter.value().newInstance();
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                ++i;
            }
        } else {
            types = null;
            Object var7_13 = null;
            converters = null;
            itemConverters = null;
            objectConverters = null;
        }
        return constructor == null && factory == null ? this.delegate.findFactory(clazz) : (constructor != null ? new AccessMode.Factory((String[])var7_14, converters, itemConverters, objectConverters){
            final /* synthetic */ String[] val$params;
            final /* synthetic */ Adapter[] val$converters;
            final /* synthetic */ Adapter[] val$itemConverters;
            final /* synthetic */ ObjectConverter.Codec[] val$objectConverters;
            {
                this.val$params = stringArray;
                this.val$converters = adapterArray;
                this.val$itemConverters = adapterArray2;
                this.val$objectConverters = codecArray;
            }

            public Object create(Object[] params) {
                try {
                    return finalConstructor.newInstance(params);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }

            public Type[] getParameterTypes() {
                return types;
            }

            public String[] getParameterNames() {
                return this.val$params;
            }

            public Adapter<?, ?>[] getParameterConverter() {
                return this.val$converters;
            }

            public Adapter<?, ?>[] getParameterItemConverter() {
                return this.val$itemConverters;
            }

            public ObjectConverter.Codec<?>[] getObjectConverter() {
                return this.val$objectConverters;
            }
        } : new AccessMode.Factory((String[])var7_14, converters, itemConverters, objectConverters){
            final /* synthetic */ String[] val$params;
            final /* synthetic */ Adapter[] val$converters;
            final /* synthetic */ Adapter[] val$itemConverters;
            final /* synthetic */ ObjectConverter.Codec[] val$objectConverters;
            {
                this.val$params = stringArray;
                this.val$converters = adapterArray;
                this.val$itemConverters = adapterArray2;
                this.val$objectConverters = codecArray;
            }

            public Object create(Object[] params) {
                try {
                    Object invoke = finalFactory.invoke(null, params);
                    if (!clazz.isInstance(invoke)) {
                        throw new IllegalArgumentException(invoke + " is not a " + clazz.getName());
                    }
                    return invoke;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }

            public Type[] getParameterTypes() {
                return types;
            }

            public String[] getParameterNames() {
                return this.val$params;
            }

            public Adapter<?, ?>[] getParameterConverter() {
                return this.val$converters;
            }

            public Adapter<?, ?>[] getParameterItemConverter() {
                return this.val$itemConverters;
            }

            public ObjectConverter.Codec<?>[] getObjectConverter() {
                return this.val$objectConverters;
            }
        });
    }

    private void validateAnnotations(Object parameter, JsonbTypeAdapter adapter, JsonbDateFormat dateFormat, JsonbNumberFormat numberFormat, JohnzonConverter johnzonConverter) {
        int notNull = adapter != null ? 1 : 0;
        notNull += dateFormat != null ? 1 : 0;
        notNull += numberFormat != null ? 1 : 0;
        if ((notNull += johnzonConverter != null ? 1 : 0) > 1) {
            throw new IllegalArgumentException("Conflicting @JsonbXXX/@JohnzonConverter on " + parameter);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Adapter<?, ?> toConverter(Type type, JsonbTypeAdapter adapter, JsonbDateFormat dateFormat, JsonbNumberFormat numberFormat) throws InstantiationException, IllegalAccessException {
        void var5_16;
        if (adapter != null) {
            Class value = adapter.value();
            ParameterizedType pt = this.findPt(value, JsonbAdapter.class);
            if (pt == null) {
                throw new IllegalArgumentException(value + " doesn't implement JsonbAdapter");
            }
            JohnzonAdapterFactory.Instance instance = this.newInstance(value);
            this.toRelease.add(instance);
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            JohnzonJsonbAdapter johnzonJsonbAdapter = new JohnzonJsonbAdapter((JsonbAdapter)instance.getValue(), actualTypeArguments[0], actualTypeArguments[1]);
            return var5_16;
        } else if (dateFormat != null) {
            if (Date.class == type) {
                ConverterAdapter converterAdapter = new ConverterAdapter((Converter)new JsonbDateConverter(dateFormat));
                return var5_16;
            } else if (LocalDateTime.class == type) {
                ConverterAdapter converterAdapter = new ConverterAdapter((Converter)new JsonbLocalDateTimeConverter(dateFormat));
                return var5_16;
            } else if (LocalDate.class == type) {
                ConverterAdapter converterAdapter = new ConverterAdapter((Converter)new JsonbLocalDateConverter(dateFormat));
                return var5_16;
            } else {
                if (ZonedDateTime.class != type) throw new IllegalArgumentException(type + " not a supported date type");
                ConverterAdapter converterAdapter = new ConverterAdapter((Converter)new JsonbZonedDateTimeConverter(dateFormat));
            }
            return var5_16;
        } else if (numberFormat != null) {
            ConverterAdapter converterAdapter = new ConverterAdapter((Converter)new JsonbNumberConverter(numberFormat));
            return var5_16;
        } else {
            ConverterAdapter converterAdapter = new ConverterAdapter((Converter)new JsonbValueConverter());
        }
        return var5_16;
    }

    private ParameterizedType findPt(Class<?> value, Class<?> type) {
        return (ParameterizedType)ParameterizedType.class.cast(Stream.of(value.getGenericInterfaces()).filter(i -> ParameterizedType.class.isInstance(i) && ((ParameterizedType)ParameterizedType.class.cast(i)).getRawType() == type).findFirst().orElse(null));
    }

    private JohnzonAdapterFactory.Instance newInstance(Class<?> value) {
        return this.factory.create(value);
    }

    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        Map readers = this.delegate.findReaders(clazz);
        Comparator<String> keyComparator = this.fieldComparator(clazz);
        HashMap<String, AccessMode.Reader> result = keyComparator == null ? new HashMap() : new TreeMap(keyComparator);
        for (Map.Entry entry : readers.entrySet()) {
            JsonbNillable nillable;
            boolean isNillable;
            Function<Object, Object> reader;
            Type type;
            FieldAndMethodAccessMode.CompositeDecoratedType decoratedType;
            AccessMode.DecoratedType type2;
            AccessMode.Reader initialReader = (AccessMode.Reader)entry.getValue();
            if (this.isTransient((AccessMode.DecoratedType)initialReader, this.visibility) || initialReader.getAnnotation(JohnzonAny.class) != null) continue;
            final AccessMode.Reader finalReader = FieldAndMethodAccessMode.CompositeDecoratedType.class.isInstance(initialReader) ? (MethodAccessMode.MethodReader.class.isInstance(type2 = (decoratedType = (FieldAndMethodAccessMode.CompositeDecoratedType)FieldAndMethodAccessMode.CompositeDecoratedType.class.cast(initialReader)).getType2()) ? (AccessMode.Reader)AccessMode.Reader.class.cast(type2) : initialReader) : initialReader;
            if (this.isOptional((AccessMode.DecoratedType)finalReader)) {
                type = ((ParameterizedType)ParameterizedType.class.cast(finalReader.getType())).getActualTypeArguments()[0];
                reader = i -> Optional.ofNullable(finalReader.read(i)).map(o -> ((Optional)Optional.class.cast(o)).orElse(null)).orElse(null);
            } else if (OptionalInt.class == finalReader.getType()) {
                type = Integer.TYPE;
                reader = i -> ((OptionalInt)OptionalInt.class.cast(finalReader.read(i))).orElse(0);
            } else if (OptionalLong.class == finalReader.getType()) {
                type = Long.TYPE;
                reader = i -> ((OptionalLong)OptionalLong.class.cast(finalReader.read(i))).orElse(0L);
            } else if (OptionalDouble.class == finalReader.getType()) {
                type = Double.TYPE;
                reader = i -> ((OptionalDouble)OptionalDouble.class.cast(finalReader.read(i))).orElse(0.0);
            } else {
                type = finalReader.getType();
                reader = arg_0 -> ((AccessMode.Reader)finalReader).read(arg_0);
            }
            final WriterConverters writerConverters = new WriterConverters((AccessMode.DecoratedType)initialReader);
            JsonbProperty property = (JsonbProperty)initialReader.getAnnotation(JsonbProperty.class);
            String key = property == null || property.value().isEmpty() ? this.naming.translateName((String)entry.getKey()) : property.value();
            if (result.put(key, new AccessMode.Reader(isNillable = (nillable = (JsonbNillable)initialReader.getClassOrPackageAnnotation(JsonbNillable.class)) != null || property != null && property.nillable()){
                final /* synthetic */ boolean val$isNillable;
                {
                    this.val$isNillable = bl;
                }

                public Object read(Object instance) {
                    return reader.apply(instance);
                }

                public ObjectConverter.Writer<?> findObjectConverterWriter() {
                    return writerConverters.writer;
                }

                public Type getType() {
                    return type;
                }

                public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                    return (T)finalReader.getAnnotation(clazz);
                }

                public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
                    return (T)finalReader.getClassOrPackageAnnotation(clazz);
                }

                public Adapter<?, ?> findConverter() {
                    return writerConverters.converter;
                }

                public boolean isNillable() {
                    return this.val$isNillable;
                }
            }) == null) continue;
            throw new JsonbException("Ambiguous field " + key);
        }
        return result;
    }

    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        Map writers = this.delegate.findWriters(clazz);
        Comparator<String> keyComparator = this.fieldComparator(clazz);
        HashMap<String, AccessMode.Writer> result = keyComparator == null ? new HashMap() : new TreeMap(keyComparator);
        for (Map.Entry entry : writers.entrySet()) {
            JsonbNillable nillable;
            boolean isNillable;
            BiConsumer<Object, Object> writer;
            Type type;
            FieldAndMethodAccessMode.CompositeDecoratedType decoratedType;
            AccessMode.DecoratedType type2;
            final AccessMode.Writer initialWriter = (AccessMode.Writer)entry.getValue();
            if (this.isTransient((AccessMode.DecoratedType)initialWriter, this.visibility)) continue;
            AccessMode.Writer finalWriter = FieldAndMethodAccessMode.CompositeDecoratedType.class.isInstance(initialWriter) ? (MethodAccessMode.MethodWriter.class.isInstance(type2 = (decoratedType = (FieldAndMethodAccessMode.CompositeDecoratedType)FieldAndMethodAccessMode.CompositeDecoratedType.class.cast(initialWriter)).getType2()) ? (AccessMode.Writer)AccessMode.Writer.class.cast(type2) : initialWriter) : initialWriter;
            if (this.isOptional((AccessMode.DecoratedType)initialWriter)) {
                type = ((ParameterizedType)ParameterizedType.class.cast(initialWriter.getType())).getActualTypeArguments()[0];
                writer = (i, val) -> finalWriter.write(i, Optional.ofNullable(val));
            } else if (OptionalInt.class == initialWriter.getType()) {
                type = Integer.TYPE;
                writer = (i, val) -> finalWriter.write(i, (Object)OptionalInt.of(((Number)Number.class.cast(val)).intValue()));
            } else if (OptionalLong.class == initialWriter.getType()) {
                type = Long.TYPE;
                writer = (i, val) -> finalWriter.write(i, (Object)OptionalLong.of(((Number)Number.class.cast(val)).longValue()));
            } else if (OptionalDouble.class == initialWriter.getType()) {
                type = Double.TYPE;
                writer = (i, val) -> finalWriter.write(i, (Object)OptionalDouble.of(((Number)Number.class.cast(val)).doubleValue()));
            } else {
                type = initialWriter.getType();
                writer = (arg_0, arg_1) -> ((AccessMode.Writer)finalWriter).write(arg_0, arg_1);
            }
            final ReaderConverters converters = new ReaderConverters((AccessMode.DecoratedType)initialWriter);
            JsonbProperty property = (JsonbProperty)initialWriter.getAnnotation(JsonbProperty.class);
            String key = property == null || property.value().isEmpty() ? this.naming.translateName((String)entry.getKey()) : property.value();
            if (result.put(key, new AccessMode.Writer(isNillable = (nillable = (JsonbNillable)initialWriter.getClassOrPackageAnnotation(JsonbNillable.class)) != null || property != null && property.nillable()){
                final /* synthetic */ boolean val$isNillable;
                {
                    this.val$isNillable = bl;
                }

                public void write(Object instance, Object val) {
                    writer.accept(instance, val);
                }

                public ObjectConverter.Reader<?> findObjectConverterReader() {
                    return converters.reader;
                }

                public Type getType() {
                    return type;
                }

                public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                    return (T)initialWriter.getAnnotation(clazz);
                }

                public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
                    return (T)initialWriter.getClassOrPackageAnnotation(clazz);
                }

                public Adapter<?, ?> findConverter() {
                    return converters.converter;
                }

                public boolean isNillable() {
                    return this.val$isNillable;
                }
            }) == null) continue;
            throw new JsonbException("Ambiguous field " + key);
        }
        return result;
    }

    public ObjectConverter.Reader<?> findReader(Class<?> clazz) {
        return this.getClassEntry(clazz).readers.reader;
    }

    public ObjectConverter.Writer<?> findWriter(Class<?> clazz) {
        return this.getClassEntry(clazz).writers.writer;
    }

    public Adapter<?, ?> findAdapter(Class<?> clazz) {
        Adapter converter = this.getClassEntry(clazz).readers.converter;
        if (converter != null && this.isReversedAdapter(clazz, converter.getClass(), converter)) {
            return new ReversedAdapter(converter);
        }
        return converter;
    }

    public Method findAnyGetter(Class<?> clazz) {
        return this.partialDelegate.findAnyGetter(clazz);
    }

    public Method findAnySetter(Class<?> clazz) {
        return this.partialDelegate.findAnySetter(clazz);
    }

    public void afterParsed(Class<?> clazz) {
        this.parsingCache.remove(clazz);
        this.partialDelegate.afterParsed(clazz);
    }

    private boolean isReversedAdapter(Class<?> payloadType, Class<?> aClass, Adapter<?, ?> instance) {
        if (TypeAwareAdapter.class.isInstance(instance)) {
            return !payloadType.isAssignableFrom((Class)Class.class.cast(((TypeAwareAdapter)TypeAwareAdapter.class.cast(instance)).getTo())) && payloadType.isAssignableFrom((Class)Class.class.cast(((TypeAwareAdapter)TypeAwareAdapter.class.cast(instance)).getFrom()));
        }
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        return Stream.of(genericInterfaces).filter(ParameterizedType.class::isInstance).filter(i -> Adapter.class.isAssignableFrom((Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(i)).getRawType()))).findFirst().map(pt -> payloadType.isAssignableFrom((Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(pt)).getActualTypeArguments()[0]))).orElseGet(() -> {
            Class superclass = aClass.getSuperclass();
            return superclass != Object.class && this.isReversedAdapter(payloadType, superclass, instance);
        });
    }

    private ParsingCacheEntry getClassEntry(Class<?> clazz) {
        ParsingCacheEntry cache = (ParsingCacheEntry)this.parsingCache.get(clazz);
        if (cache == null) {
            cache = new ParsingCacheEntry(new ClassDecoratedType(clazz));
            this.parsingCache.putIfAbsent(clazz, cache);
        }
        return cache;
    }

    private boolean isOptional(AccessMode.DecoratedType value) {
        return ParameterizedType.class.isInstance(value.getType()) && Optional.class == ((ParameterizedType)ParameterizedType.class.cast(value.getType())).getRawType();
    }

    private boolean isTransient(AccessMode.DecoratedType dt, PropertyVisibilityStrategy visibility) {
        if (!FieldAndMethodAccessMode.CompositeDecoratedType.class.isInstance(dt)) {
            return this.isTransient(dt) || this.shouldSkip(visibility, dt);
        }
        FieldAndMethodAccessMode.CompositeDecoratedType cdt = (FieldAndMethodAccessMode.CompositeDecoratedType)FieldAndMethodAccessMode.CompositeDecoratedType.class.cast(dt);
        return this.isTransient(cdt.getType1()) || this.isTransient(cdt.getType2()) || this.shouldSkip(visibility, cdt.getType1()) && this.shouldSkip(visibility, cdt.getType2());
    }

    private boolean shouldSkip(PropertyVisibilityStrategy visibility, AccessMode.DecoratedType t) {
        return this.isNotVisible(visibility, t);
    }

    private boolean isTransient(AccessMode.DecoratedType t) {
        return t.getAnnotation(JsonbTransient.class) != null;
    }

    private boolean isNotVisible(PropertyVisibilityStrategy visibility, AccessMode.DecoratedType t) {
        return !(!FieldAccessMode.FieldDecoratedType.class.isInstance(t) ? MethodAccessMode.MethodDecoratedType.class.isInstance(t) && visibility.isVisible(((MethodAccessMode.MethodDecoratedType)MethodAccessMode.MethodDecoratedType.class.cast(t)).getMethod()) : visibility.isVisible(((FieldAccessMode.FieldDecoratedType)FieldAccessMode.FieldDecoratedType.class.cast(t)).getField()));
    }

    private Comparator<String> orderComparator(Class<?> clazz) {
        Comparator keyComparator;
        JsonbPropertyOrder orderAnnotation = (JsonbPropertyOrder)Meta.getAnnotation(clazz, JsonbPropertyOrder.class);
        if (orderAnnotation != null) {
            ArrayList<String> indexed = new ArrayList<String>(Arrays.asList(orderAnnotation.value()));
            if (this.naming != null) {
                for (int i = 0; i < indexed.size(); ++i) {
                    indexed.set(i, this.naming.translateName((String)indexed.get(i)));
                }
            }
            keyComparator = (o1, o2) -> {
                int i1 = indexed.indexOf(o1);
                int i2 = indexed.indexOf(o2);
                if (i1 < 0) {
                    if (i2 < 0 && this.order != null) {
                        switch (this.order) {
                            case "LEXICOGRAPHICAL": {
                                return o1.compareTo((String)o2);
                            }
                            case "REVERSE": {
                                return o2.compareTo((String)o1);
                            }
                        }
                        return 1;
                    }
                    return 1;
                }
                return i1 - i2;
            };
        } else if (this.order != null) {
            switch (this.order) {
                case "ANY": {
                    keyComparator = null;
                    break;
                }
                case "LEXICOGRAPHICAL": {
                    keyComparator = String::compareTo;
                    break;
                }
                case "REVERSE": {
                    keyComparator = Comparator.reverseOrder();
                    break;
                }
                default: {
                    keyComparator = null;
                    break;
                }
            }
        } else {
            keyComparator = null;
        }
        return keyComparator;
    }

    @Override
    public void close() throws IOException {
        this.toRelease.forEach(JohnzonAdapterFactory.Instance::release);
        if (Closeable.class.isInstance(this.delegate)) {
            ((Closeable)Closeable.class.cast(this.delegate)).close();
        }
        this.toRelease.clear();
    }

    private static <T extends Annotation> T getAnnotation(Parameter param, Class<T> api) {
        T annotation = param.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        return (T)Meta.findMeta((Annotation[])param.getAnnotations(), api);
    }

    private class ParsingCacheEntry {
        private final ReaderConverters readers;
        private final WriterConverters writers;

        ParsingCacheEntry(AccessMode.DecoratedType type) {
            this.readers = new ReaderConverters(type);
            this.writers = new WriterConverters(type);
        }
    }

    private static class ClassDecoratedType
    implements AccessMode.DecoratedType {
        private final Class<?> annotations;

        ClassDecoratedType(Class<?> clazz) {
            this.annotations = clazz;
        }

        public Type getType() {
            return this.annotations;
        }

        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return (T)Meta.getAnnotation(this.annotations, clazz);
        }

        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return (T)Meta.getAnnotation((Package)clazz.getPackage(), clazz);
        }

        public Adapter<?, ?> findConverter() {
            return null;
        }

        public boolean isNillable() {
            return false;
        }
    }

    private class WriterConverters {
        private Adapter<?, ?> converter;
        private ObjectConverter.Writer writer;

        WriterConverters(AccessMode.DecoratedType initialReader) {
            JsonbTypeSerializer serializer = (JsonbTypeSerializer)initialReader.getAnnotation(JsonbTypeSerializer.class);
            JsonbTypeAdapter adapter = (JsonbTypeAdapter)initialReader.getAnnotation(JsonbTypeAdapter.class);
            JsonbDateFormat dateFormat = (JsonbDateFormat)initialReader.getAnnotation(JsonbDateFormat.class);
            JsonbNumberFormat numberFormat = (JsonbNumberFormat)initialReader.getAnnotation(JsonbNumberFormat.class);
            JohnzonConverter johnzonConverter = (JohnzonConverter)initialReader.getAnnotation(JohnzonConverter.class);
            JsonbAccessMode.this.validateAnnotations(initialReader, adapter, dateFormat, numberFormat, johnzonConverter);
            try {
                this.converter = adapter == null && dateFormat == null && numberFormat == null && johnzonConverter == null ? (Adapter)JsonbAccessMode.this.defaultConverters.get(new AdapterKey(initialReader.getType(), String.class)) : JsonbAccessMode.this.toConverter(initialReader.getType(), adapter, dateFormat, numberFormat);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            if (serializer != null) {
                Class value = serializer.value();
                ParameterizedType pt = JsonbAccessMode.this.findPt(value, JsonbSerializer.class);
                if (pt == null) {
                    throw new IllegalArgumentException(value + " doesn't implement JsonbSerializer");
                }
                JohnzonAdapterFactory.Instance instance = JsonbAccessMode.this.newInstance(value);
                JsonbAccessMode.this.toRelease.add(instance);
                this.writer = (instance1, jsonbGenerator) -> ((JsonbSerializer)instance.getValue()).serialize(instance1, jsonbGenerator.getJsonGenerator(), (SerializationContext)new JohnzonSerializationContext(jsonbGenerator));
            } else if (johnzonConverter != null) {
                try {
                    MapperConverter mapperConverter = (MapperConverter)johnzonConverter.value().newInstance();
                    if (mapperConverter instanceof Converter) {
                        this.converter = new ConverterAdapter((Converter)mapperConverter);
                    } else if (mapperConverter instanceof ObjectConverter.Writer) {
                        this.writer = (ObjectConverter.Writer)mapperConverter;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    private class ReaderConverters {
        private Adapter<?, ?> converter;
        private ObjectConverter.Reader reader;

        ReaderConverters(AccessMode.DecoratedType annotationHolder) {
            JsonbTypeDeserializer deserializer = (JsonbTypeDeserializer)annotationHolder.getAnnotation(JsonbTypeDeserializer.class);
            JsonbTypeAdapter adapter = (JsonbTypeAdapter)annotationHolder.getAnnotation(JsonbTypeAdapter.class);
            JsonbDateFormat dateFormat = (JsonbDateFormat)annotationHolder.getAnnotation(JsonbDateFormat.class);
            JsonbNumberFormat numberFormat = (JsonbNumberFormat)annotationHolder.getAnnotation(JsonbNumberFormat.class);
            JohnzonConverter johnzonConverter = (JohnzonConverter)annotationHolder.getAnnotation(JohnzonConverter.class);
            JsonbAccessMode.this.validateAnnotations(annotationHolder, adapter, dateFormat, numberFormat, johnzonConverter);
            try {
                this.converter = adapter == null && dateFormat == null && numberFormat == null && johnzonConverter == null ? (Adapter)JsonbAccessMode.this.defaultConverters.get(new AdapterKey(annotationHolder.getType(), String.class)) : JsonbAccessMode.this.toConverter(annotationHolder.getType(), adapter, dateFormat, numberFormat);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            if (deserializer != null) {
                Class value = deserializer.value();
                ParameterizedType pt = JsonbAccessMode.this.findPt(value, JsonbDeserializer.class);
                if (pt == null) {
                    throw new IllegalArgumentException(value + " doesn't implement JsonbDeserializer");
                }
                JohnzonAdapterFactory.Instance instance = JsonbAccessMode.this.newInstance(value);
                JsonbAccessMode.this.toRelease.add(instance);
                this.reader = (jsonObject, targetType, parser) -> ((JsonbDeserializer)instance.getValue()).deserialize(((JsonParserFactory)JsonbAccessMode.this.parserFactory.get()).createParser(jsonObject), (DeserializationContext)new JohnzonDeserializationContext(parser), targetType);
            } else if (johnzonConverter != null) {
                try {
                    MapperConverter mapperConverter = (MapperConverter)johnzonConverter.value().newInstance();
                    if (mapperConverter instanceof Converter) {
                        this.converter = new ConverterAdapter((Converter)mapperConverter);
                    } else if (mapperConverter instanceof ObjectConverter.Reader) {
                        this.reader = (ObjectConverter.Reader)mapperConverter;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }
}

