/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.set.OpenIntHashSet;

public abstract class VectorBinaryAssign {
    public static final VectorBinaryAssign[] OPERATIONS = new VectorBinaryAssign[]{new AssignNonzerosIterateThisLookupThat(), new AssignNonzerosIterateThatLookupThisMergeUpdates(), new AssignNonzerosIterateThatLookupThisInplaceUpdates(), new AssignIterateIntersection(), new AssignIterateUnionSequentialMergeUpdates(), new AssignIterateUnionSequentialInplaceUpdates(), new AssignIterateUnionRandomMergeUpdates(), new AssignIterateUnionRandomInplaceUpdates(), new AssignAllIterateSequentialMergeUpdates(), new AssignAllIterateSequentialInplaceUpdates(), new AssignAllIterateThisLookupThatMergeUpdates(), new AssignAllIterateThisLookupThatInplaceUpdates(), new AssignAllIterateThatLookupThisMergeUpdates(), new AssignAllIterateThatLookupThisInplaceUpdates(), new AssignAllLoopMergeUpdates(), new AssignAllLoopInplaceUpdates()};

    public abstract boolean isValid(Vector var1, Vector var2, DoubleDoubleFunction var3);

    public abstract double estimateCost(Vector var1, Vector var2, DoubleDoubleFunction var3);

    public abstract Vector assign(Vector var1, Vector var2, DoubleDoubleFunction var3);

    public static VectorBinaryAssign getBestOperation(Vector x, Vector y, DoubleDoubleFunction f2) {
        int bestOperationIndex = -1;
        double bestCost = Double.POSITIVE_INFINITY;
        for (int i = 0; i < OPERATIONS.length; ++i) {
            double cost;
            if (!OPERATIONS[i].isValid(x, y, f2) || !((cost = OPERATIONS[i].estimateCost(x, y, f2)) < bestCost)) continue;
            bestCost = cost;
            bestOperationIndex = i;
        }
        return OPERATIONS[bestOperationIndex];
    }

    public static Vector assignBest(Vector x, Vector y, DoubleDoubleFunction f2) {
        return VectorBinaryAssign.getBestOperation(x, y, f2).assign(x, y, f2);
    }

    public static class AssignAllLoopInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return x.isAddConstantTime();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)x.size() * x.getLookupCost() * y.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            for (int i = 0; i < x.size(); ++i) {
                x.setQuick(i, f2.apply(x.getQuick(i), y.getQuick(i)));
            }
            return x;
        }
    }

    public static class AssignAllLoopMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !x.isAddConstantTime();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)x.size() * x.getLookupCost() * y.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            for (int i = 0; i < x.size(); ++i) {
                updates.set(i, f2.apply(x.getQuick(i), y.getQuick(i)));
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignAllIterateThatLookupThisInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return x.isAddConstantTime() && !y.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)y.size() * y.getIteratorAdvanceCost() * x.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            for (Vector.Element ye : y.all()) {
                x.setQuick(ye.index(), f2.apply(x.getQuick(ye.index()), ye.get()));
            }
            return x;
        }
    }

    public static class AssignAllIterateThatLookupThisMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !x.isAddConstantTime() && !y.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)y.size() * y.getIteratorAdvanceCost() * x.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            for (Vector.Element ye : y.all()) {
                updates.set(ye.index(), f2.apply(x.getQuick(ye.index()), ye.get()));
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignAllIterateThisLookupThatInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return x.isAddConstantTime() && !x.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)x.size() * x.getIteratorAdvanceCost() * y.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            for (Vector.Element xe : x.all()) {
                x.setQuick(xe.index(), f2.apply(xe.get(), y.getQuick(xe.index())));
            }
            return x;
        }
    }

    public static class AssignAllIterateThisLookupThatMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !x.isAddConstantTime() && !x.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)x.size() * x.getIteratorAdvanceCost() * y.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            for (Vector.Element xe : x.all()) {
                updates.set(xe.index(), f2.apply(xe.get(), y.getQuick(xe.index())));
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignAllIterateSequentialInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return x.isSequentialAccess() && y.isSequentialAccess() && x.isAddConstantTime() && !x.isDense() && !y.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.max((double)x.size() * x.getIteratorAdvanceCost(), (double)y.size() * y.getIteratorAdvanceCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            Iterator<Vector.Element> xi = x.all().iterator();
            Iterator<Vector.Element> yi = y.all().iterator();
            while (xi.hasNext() && yi.hasNext()) {
                Vector.Element xe = xi.next();
                x.setQuick(xe.index(), f2.apply(xe.get(), yi.next().get()));
            }
            return x;
        }
    }

    public static class AssignAllIterateSequentialMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return x.isSequentialAccess() && y.isSequentialAccess() && !x.isAddConstantTime() && !x.isDense() && !y.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.max((double)x.size() * x.getIteratorAdvanceCost(), (double)y.size() * y.getIteratorAdvanceCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            Iterator<Vector.Element> xi = x.all().iterator();
            Iterator<Vector.Element> yi = y.all().iterator();
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            while (xi.hasNext() && yi.hasNext()) {
                Vector.Element xe = xi.next();
                updates.set(xe.index(), f2.apply(xe.get(), yi.next().get()));
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignIterateUnionRandomInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !f2.isDensifying() && x.isAddConstantTime();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.max((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost() * y.getLookupCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost() * x.getLookupCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            OpenIntHashSet visited = new OpenIntHashSet();
            for (Vector.Element xe : x.nonZeroes()) {
                xe.set(f2.apply(xe.get(), y.getQuick(xe.index())));
                visited.add(xe.index());
            }
            for (Vector.Element ye : y.nonZeroes()) {
                if (visited.contains(ye.index())) continue;
                x.setQuick(ye.index(), f2.apply(x.getQuick(ye.index()), ye.get()));
            }
            return x;
        }
    }

    public static class AssignIterateUnionRandomMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !f2.isDensifying() && !x.isAddConstantTime() && y.isSequentialAccess();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.max((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost() * y.getLookupCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost() * x.getLookupCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            OpenIntHashSet visited = new OpenIntHashSet();
            for (Vector.Element xe : x.nonZeroes()) {
                xe.set(f2.apply(xe.get(), y.getQuick(xe.index())));
                visited.add(xe.index());
            }
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            for (Vector.Element ye : y.nonZeroes()) {
                if (visited.contains(ye.index())) continue;
                updates.set(ye.index(), f2.apply(x.getQuick(ye.index()), ye.get()));
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignIterateUnionSequentialInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !f2.isDensifying() && x.isSequentialAccess() && y.isSequentialAccess() && x.isAddConstantTime();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.max((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            Iterator<Vector.Element> yi = y.nonZeroes().iterator();
            Vector.Element xe = null;
            Vector.Element ye = null;
            boolean advanceThis = true;
            boolean advanceThat = true;
            while (true) {
                if (advanceThis) {
                    xe = xi.hasNext() ? xi.next() : null;
                }
                if (advanceThat) {
                    ye = yi.hasNext() ? yi.next() : null;
                }
                if (xe != null && ye != null) {
                    if (xe.index() == ye.index()) {
                        xe.set(f2.apply(xe.get(), ye.get()));
                        advanceThis = true;
                        advanceThat = true;
                        continue;
                    }
                    if (xe.index() < ye.index()) {
                        xe.set(f2.apply(xe.get(), 0.0));
                        advanceThis = true;
                        advanceThat = false;
                        continue;
                    }
                    x.setQuick(ye.index(), f2.apply(0.0, ye.get()));
                    advanceThis = false;
                    advanceThat = true;
                    continue;
                }
                if (xe != null) {
                    xe.set(f2.apply(xe.get(), 0.0));
                    advanceThis = true;
                    advanceThat = false;
                    continue;
                }
                if (ye == null) break;
                x.setQuick(ye.index(), f2.apply(0.0, ye.get()));
                advanceThis = false;
                advanceThat = true;
            }
            return x;
        }
    }

    public static class AssignIterateUnionSequentialMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return !f2.isDensifying() && x.isSequentialAccess() && y.isSequentialAccess() && !x.isAddConstantTime();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.max((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            Iterator<Vector.Element> yi = y.nonZeroes().iterator();
            Vector.Element xe = null;
            Vector.Element ye = null;
            boolean advanceThis = true;
            boolean advanceThat = true;
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            while (true) {
                if (advanceThis) {
                    xe = xi.hasNext() ? xi.next() : null;
                }
                if (advanceThat) {
                    ye = yi.hasNext() ? yi.next() : null;
                }
                if (xe != null && ye != null) {
                    if (xe.index() == ye.index()) {
                        xe.set(f2.apply(xe.get(), ye.get()));
                        advanceThis = true;
                        advanceThat = true;
                        continue;
                    }
                    if (xe.index() < ye.index()) {
                        xe.set(f2.apply(xe.get(), 0.0));
                        advanceThis = true;
                        advanceThat = false;
                        continue;
                    }
                    updates.set(ye.index(), f2.apply(0.0, ye.get()));
                    advanceThis = false;
                    advanceThat = true;
                    continue;
                }
                if (xe != null) {
                    xe.set(f2.apply(xe.get(), 0.0));
                    advanceThis = true;
                    advanceThat = false;
                    continue;
                }
                if (ye == null) break;
                updates.set(ye.index(), f2.apply(0.0, ye.get()));
                advanceThis = false;
                advanceThat = true;
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignIterateIntersection
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return f2.isLikeLeftMult() && f2.isLikeRightPlus() && x.isSequentialAccess() && y.isSequentialAccess();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return Math.min((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost());
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            Iterator<Vector.Element> yi = y.nonZeroes().iterator();
            Vector.Element xe = null;
            Vector.Element ye = null;
            boolean advanceThis = true;
            boolean advanceThat = true;
            while (true) {
                if (advanceThis) {
                    if (!xi.hasNext()) break;
                    xe = xi.next();
                }
                if (advanceThat) {
                    if (!yi.hasNext()) break;
                    ye = yi.next();
                }
                if (xe.index() == ye.index()) {
                    xe.set(f2.apply(xe.get(), ye.get()));
                    advanceThis = true;
                    advanceThat = true;
                    continue;
                }
                if (xe.index() < ye.index()) {
                    advanceThis = true;
                    advanceThat = false;
                    continue;
                }
                advanceThis = false;
                advanceThat = true;
            }
            return x;
        }
    }

    public static class AssignNonzerosIterateThatLookupThisMergeUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return f2.isLikeRightPlus() && y.isSequentialAccess() && !x.isAddConstantTime();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost() * y.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            OrderedIntDoubleMapping updates = new OrderedIntDoubleMapping(false);
            for (Vector.Element ye : y.nonZeroes()) {
                updates.set(ye.index(), f2.apply(x.getQuick(ye.index()), ye.get()));
            }
            x.mergeUpdates(updates);
            return x;
        }
    }

    public static class AssignNonzerosIterateThatLookupThisInplaceUpdates
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return f2.isLikeRightPlus();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost() * x.getLookupCost() * x.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            for (Vector.Element ye : y.nonZeroes()) {
                x.setQuick(ye.index(), f2.apply(x.getQuick(ye.index()), ye.get()));
            }
            return x;
        }
    }

    public static class AssignNonzerosIterateThisLookupThat
    extends VectorBinaryAssign {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction f2) {
            return f2.isLikeLeftMult();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction f2) {
            return (double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost() * y.getLookupCost();
        }

        @Override
        public Vector assign(Vector x, Vector y, DoubleDoubleFunction f2) {
            for (Vector.Element xe : x.nonZeroes()) {
                xe.set(f2.apply(xe.get(), y.getQuick(xe.index())));
            }
            return x;
        }
    }
}

