/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

public class OnlineSummarizer {
    private double mean;
    private double variance;
    private int n;

    public void add(double sample) {
        ++this.n;
        double oldMean = this.mean;
        this.mean += (sample - this.mean) / (double)this.n;
        double diff = (sample - this.mean) * (sample - oldMean);
        this.variance += (diff - this.variance) / (double)this.n;
    }

    public int getCount() {
        return this.n;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSD() {
        return Math.sqrt(this.variance);
    }
}

