/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.commons.validator.ValidatorBase;
import org.apache.myfaces.commons.validator.model.DateListProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateRestrictionValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.commons.validator.DateRestriction";
    public static final String DAY_MESSAGE_ID = "org.apache.myfaces.commons.validator.DateRestrictionValidator.DAY";
    public static final String MONTH_MESSAGE_ID = "org.apache.myfaces.commons.validator.DateRestrictionValidator.MONTH";
    public static final String WEEKDAY_MESSAGE_ID = "org.apache.myfaces.commons.validator.DateRestrictionValidator.WEEKDAY";
    private Map<Integer, String> _dayMap = null;
    private Map<Integer, String> _monthMap = null;

    public AbstractDateRestrictionValidator() {
        this._initMaps();
    }

    public abstract String[] getInvalidMonths();

    public abstract void setInvalidMonths(String[] var1);

    public abstract String[] getInvalidDaysOfWeek();

    public abstract void setInvalidDaysOfWeek(String[] var1);

    public abstract DateListProvider getInvalidDays();

    public abstract void setInvalidDays(DateListProvider var1);

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException("NULL_FACESCONTEXT_OR_UICOMPONENT");
        }
        if (value != null) {
            Calendar calendar = this.getCalendar();
            calendar.setTime(AbstractDateRestrictionValidator.getDateValue(value));
            Date convertedDate = calendar.getTime();
            String weekday = this._dayMap.get(calendar.get(7));
            if (this._getInvalidDaysOfWeek().contains(weekday)) {
                throw new ValidatorException(this.getWrongWeekDayMessage(context, component, value, weekday));
            }
            String month = this._monthMap.get(calendar.get(2));
            if (this._getInvalidMonths().contains(month)) {
                throw new ValidatorException(this.getWrongMonthMessage(context, component, value, month));
            }
            DateListProvider dlp = this.getInvalidDays();
            List<Date> dates = null;
            if (dlp != null) {
                dates = dlp.getDateList(context, calendar, calendar.getTime(), calendar.getTime());
            }
            if (dates != null) {
                for (Date date : dates) {
                    if (date.before(convertedDate) || date.after(convertedDate)) continue;
                    throw new ValidatorException(this.getWrongDayMessage(context, component, value, date));
                }
            }
        }
    }

    private Converter getConverter(FacesContext context, UIComponent component) {
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            converter = context.getApplication().createConverter("javax.faces.DateTime");
        }
        assert (converter != null);
        return converter;
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance();
    }

    protected static Date getDateValue(Object value) throws IllegalArgumentException {
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("value is not a date type");
    }

    private FacesMessage getWrongWeekDayMessage(FacesContext context, UIComponent component, Object value, Object weekday) {
        Converter converter = this.getConverter(context, component);
        Object cWeekday = this._getConvertedValue(context, component, converter, weekday);
        Object[] params = new Object[]{cWeekday};
        return this.getFacesMessage(WEEKDAY_MESSAGE_ID, params);
    }

    private FacesMessage getWrongMonthMessage(FacesContext context, UIComponent component, Object value, Object month) {
        Converter converter = this.getConverter(context, component);
        Object cMonth = this._getConvertedValue(context, component, converter, month);
        Object[] params = new Object[]{cMonth};
        return this.getFacesMessage(MONTH_MESSAGE_ID, params);
    }

    private FacesMessage getWrongDayMessage(FacesContext context, UIComponent component, Object value, Object day) {
        Converter converter = this.getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cDay = this._getConvertedValue(context, component, converter, day);
        Object[] params = new Object[]{cValue, cDay};
        return this.getFacesMessage(DAY_MESSAGE_ID, params);
    }

    private Object _getConvertedValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        return converter.getAsString(context, component, value);
    }

    private final Set<String> _getInvalidMonths() {
        HashSet<String> monthSet = new HashSet<String>();
        String[] month = this.getInvalidMonths();
        if (month != null) {
            for (int i = 0; i < month.length; ++i) {
                monthSet.add(month[i].toLowerCase());
            }
        }
        return monthSet;
    }

    private final Set<String> _getInvalidDaysOfWeek() {
        HashSet<String> daysOfWeekSet = new HashSet<String>();
        String[] daysOfWeek = this.getInvalidDaysOfWeek();
        if (daysOfWeek != null) {
            for (int i = 0; i < daysOfWeek.length; ++i) {
                daysOfWeekSet.add(daysOfWeek[i].toLowerCase());
            }
        }
        return daysOfWeekSet;
    }

    private void _initMaps() {
        this._dayMap = new HashMap<Integer, String>();
        this._dayMap.put(1, "sun");
        this._dayMap.put(2, "mon");
        this._dayMap.put(3, "tue");
        this._dayMap.put(4, "wed");
        this._dayMap.put(5, "thu");
        this._dayMap.put(6, "fri");
        this._dayMap.put(7, "sat");
        this._monthMap = new HashMap<Integer, String>();
        this._monthMap.put(0, "jan");
        this._monthMap.put(1, "feb");
        this._monthMap.put(2, "mar");
        this._monthMap.put(3, "apr");
        this._monthMap.put(4, "may");
        this._monthMap.put(5, "jun");
        this._monthMap.put(6, "jul");
        this._monthMap.put(7, "aug");
        this._monthMap.put(8, "sep");
        this._monthMap.put(9, "oct");
        this._monthMap.put(10, "nov");
        this._monthMap.put(11, "dec");
    }
}

