/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.text.MessageFormat;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

class _ParametrizableFacesMessage
extends FacesMessage {
    private static final long serialVersionUID = 7792947730961657948L;
    private final Object[] _args;
    private String _evaluatedDetail;
    private String _evaluatedSummary;
    private transient Object[] _evaluatedArgs;
    private Locale _locale;

    public _ParametrizableFacesMessage(String summary, String detail, Object[] args, Locale locale) {
        super(summary, detail);
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        this._locale = locale;
        this._args = args;
    }

    public _ParametrizableFacesMessage(FacesMessage.Severity severity, String summary, String detail, Object[] args, Locale locale) {
        super(severity, summary, detail);
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        this._locale = locale;
        this._args = args;
    }

    @Override
    public String getDetail() {
        if (this._evaluatedArgs == null && this._args != null) {
            this.evaluateArgs();
        }
        if (this._evaluatedDetail == null) {
            MessageFormat format = new MessageFormat(super.getDetail(), this._locale);
            this._evaluatedDetail = format.format(this._evaluatedArgs);
        }
        return this._evaluatedDetail;
    }

    @Override
    public void setDetail(String detail) {
        super.setDetail(detail);
        this._evaluatedDetail = null;
    }

    public String getUnformattedDetail() {
        return super.getDetail();
    }

    @Override
    public String getSummary() {
        if (this._evaluatedArgs == null && this._args != null) {
            this.evaluateArgs();
        }
        if (this._evaluatedSummary == null) {
            MessageFormat format = new MessageFormat(super.getSummary(), this._locale);
            this._evaluatedSummary = format.format(this._evaluatedArgs);
        }
        return this._evaluatedSummary;
    }

    @Override
    public void setSummary(String summary) {
        super.setSummary(summary);
        this._evaluatedSummary = null;
    }

    public String getUnformattedSummary() {
        return super.getSummary();
    }

    private void evaluateArgs() {
        this._evaluatedArgs = new Object[this._args.length];
        FacesContext facesContext = null;
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i] == null) continue;
            if (this._args[i] instanceof ValueBinding) {
                if (facesContext == null) {
                    facesContext = FacesContext.getCurrentInstance();
                }
                this._evaluatedArgs[i] = ((ValueBinding)this._args[i]).getValue(facesContext);
                continue;
            }
            if (this._args[i] instanceof ValueExpression) {
                if (facesContext == null) {
                    facesContext = FacesContext.getCurrentInstance();
                }
                this._evaluatedArgs[i] = ((ValueExpression)this._args[i]).getValue(facesContext.getELContext());
                continue;
            }
            this._evaluatedArgs[i] = this._args[i];
        }
    }
}

