/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.Expression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import javax.faces.view.Location;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.html.HtmlResponseWriterImpl;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.StateUtils;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;
import org.apache.myfaces.view.facelets.component.UIRepeat;
import org.apache.myfaces.view.facelets.el.ContextAware;

public final class ErrorPageWriter {
    public static final String ERROR_PAGE_BEAN_KEY = "__myFacesErrorPageBean";
    private static final String EXCEPTION_KEY = "javax.servlet.error.exception";
    public static final String VIEW_KEY = "org.apache.myfaces.error.UIViewRoot";
    private static final Logger log = Logger.getLogger(ErrorPageWriter.class.getName());
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/rsc/myfaces-dev-error.xml";
    private static final String ERROR_TEMPLATE_RESOURCE = "org.apache.myfaces.ERROR_TEMPLATE_RESOURCE";
    private static String[] errorParts;
    private static final String DEBUG_TEMPLATE = "META-INF/rsc/myfaces-dev-debug.xml";
    private static final String DEBUG_TEMPLATE_RESOURCE = "org.apache.myfaces.DEBUG_TEMPLATE_RESOURCE";
    private static String[] debugParts;
    private static final String REGEX_PATTERN = ".*?\\Q,Id:\\E\\s*(\\S+)\\s*\\].*?";
    private static final String[] IGNORE;
    private static final String[] ALWAYS_WRITE;
    public static final String DEBUG_INFO_KEY = "org.apache.myfaces.debug.DEBUG_INFO";
    private static final String VISITED_FACET_COUNT_KEY = "org.apache.myfaces.debug.VISITED_FACET_COUNT";
    public static final String ERROR_HANDLING_PARAMETER = "org.apache.myfaces.ERROR_HANDLING";

    public static void debugHtml(Writer writer, FacesContext faces, Throwable e) throws IOException {
        ErrorPageWriter.debugHtml(writer, faces, faces.getViewRoot(), null, e);
    }

    /*
     * WARNING - void declaration
     */
    private static void debugHtml(Writer writer, FacesContext faces, UIViewRoot view, Collection<UIComponent> components, Throwable ... exs) throws IOException {
        ErrorPageWriter._init(faces);
        Date now = new Date();
        for (int i = 0; i < errorParts.length; ++i) {
            int n;
            if ("view".equals(errorParts[i])) {
                void var8_15;
                if (faces.getViewRoot() == null) continue;
                String viewId = faces.getViewRoot().getViewId();
                writer.write("viewId=" + viewId);
                writer.write("<br/>");
                Object var8_13 = null;
                try {
                    String string = faces.getExternalContext().getRealPath(viewId);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (var8_15 != null) {
                    writer.write("location=" + (String)var8_15);
                    writer.write("<br/>");
                }
                writer.write("phaseId=" + faces.getCurrentPhaseId());
                writer.write("<br/>");
                writer.write("<br/>");
                continue;
            }
            if ("message".equals(errorParts[i])) {
                boolean printed = false;
                Throwable[] throwableArray = exs;
                int n2 = throwableArray.length;
                for (n = 0; n < n2; ++n) {
                    Throwable e = throwableArray[n];
                    String msg = e.getMessage();
                    if (printed) {
                        writer.write("<br/>");
                    }
                    if (msg != null) {
                        writer.write(msg.replaceAll("<", TS));
                    } else {
                        writer.write(e.getClass().getName());
                    }
                    printed = true;
                }
                continue;
            }
            if ("trace".equals(errorParts[i])) {
                boolean printed = false;
                Throwable[] throwableArray = exs;
                int n3 = throwableArray.length;
                for (n = 0; n < n3; ++n) {
                    Throwable e = throwableArray[n];
                    if (printed) {
                        writer.write("\n");
                    }
                    ErrorPageWriter._writeException(writer, e);
                    printed = true;
                }
                continue;
            }
            if ("now".equals(errorParts[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(errorParts[i])) {
                if (view == null) continue;
                List<String> errorIds = ErrorPageWriter._getErrorId(components, exs);
                ErrorPageWriter._writeComponent(faces, writer, (UIComponent)view, errorIds, true);
                continue;
            }
            if ("vars".equals(errorParts[i])) {
                ErrorPageWriter._writeVariables(writer, faces, view);
                continue;
            }
            if ("cause".equals(errorParts[i])) {
                boolean printed = false;
                Object var8_18 = null;
                if (components != null) {
                    Iterator<UIComponent> iterator = components.iterator();
                }
                Throwable[] throwableArray = exs;
                n = throwableArray.length;
                for (int j = 0; j < n; ++j) {
                    UIComponent uiComponent;
                    void var8_20;
                    Throwable e = throwableArray[j];
                    if (printed) {
                        writer.write("<br/>");
                    }
                    ErrorPageWriter._writeCause(writer, e);
                    if (var8_20 != null && (uiComponent = (UIComponent)var8_20.next()) != null) {
                        ErrorPageWriter._writeComponent(faces, writer, uiComponent, null, false);
                    }
                    printed = true;
                }
                continue;
            }
            writer.write(errorParts[i]);
        }
    }

    public static void debugHtml(Writer writer, FacesContext faces) throws IOException {
        ErrorPageWriter._init(faces);
        Date now = new Date();
        for (int i = 0; i < debugParts.length; ++i) {
            if ("message".equals(debugParts[i])) {
                writer.write(faces.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(debugParts[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(debugParts[i])) {
                ErrorPageWriter._writeComponent(faces, writer, (UIComponent)faces.getViewRoot(), null, true);
                continue;
            }
            if ("extendedtree".equals(debugParts[i])) {
                ErrorPageWriter._writeExtendedComponentTree(writer, faces);
                continue;
            }
            if ("vars".equals(debugParts[i])) {
                ErrorPageWriter._writeVariables(writer, faces, faces.getViewRoot());
                continue;
            }
            writer.write(debugParts[i]);
        }
    }

    public static void handle(FacesContext facesContext, Collection<UIComponent> components, Throwable ... exs) throws FacesException {
        for (Throwable ex : exs) {
            ErrorPageWriter._prepareExceptionStack(ex);
        }
        if (!facesContext.getExternalContext().isResponseCommitted()) {
            facesContext.getExternalContext().responseReset();
        }
        int responseStatus = -1;
        for (Throwable ex : exs) {
            if (ex instanceof ViewNotFoundException) {
                responseStatus = 404;
                break;
            }
            responseStatus = 500;
        }
        if (responseStatus != -1) {
            facesContext.getExternalContext().setResponseStatus(responseStatus);
        }
        facesContext.getExternalContext().setResponseContentType("text/html");
        facesContext.getExternalContext().setResponseCharacterEncoding("UTF-8");
        try {
            Writer writer = facesContext.getExternalContext().getResponseOutputWriter();
            ErrorPageWriter.debugHtml(writer, facesContext, facesContext.getViewRoot(), components, exs);
        }
        catch (IOException ioe) {
            throw new FacesException("Could not write the error page", (Throwable)ioe);
        }
        facesContext.responseComplete();
    }

    @Deprecated
    public static void handleThrowable(FacesContext facesContext, Throwable ex) throws FacesException {
        ErrorPageWriter._prepareExceptionStack(ex);
        boolean errorPageWritten = false;
        WebConfigProvider webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext());
        if (webConfigProvider.isErrorPagePresent(facesContext.getExternalContext())) {
            facesContext.getExternalContext().getRequestMap().put(VIEW_KEY, facesContext.getViewRoot());
        } else {
            HttpServletResponse httpResp;
            Object response;
            boolean errorHandlingDisabled;
            String errorHandling = facesContext.getExternalContext().getInitParameter(ERROR_HANDLING_PARAMETER);
            boolean bl = errorHandlingDisabled = errorHandling != null && errorHandling.equalsIgnoreCase("false");
            if (!errorHandlingDisabled && (response = facesContext.getExternalContext().getResponse()) instanceof HttpServletResponse && !(httpResp = (HttpServletResponse)response).isCommitted()) {
                httpResp.reset();
                if (facesContext.getPartialViewContext().isAjaxRequest()) {
                    httpResp.setContentType("text/xml; charset=UTF-8");
                    try {
                        PrintWriter writer = httpResp.getWriter();
                        HtmlResponseWriterImpl responseWriter = new HtmlResponseWriterImpl(writer, "text/xml", "utf-8");
                        PartialResponseWriter partialWriter = new PartialResponseWriter((ResponseWriter)responseWriter);
                        partialWriter.startDocument();
                        partialWriter.startError(ex.getClass().getName());
                        if (ex.getCause() != null) {
                            partialWriter.write(ex.getCause().toString());
                        } else if (ex.getMessage() != null) {
                            partialWriter.write(ex.getMessage());
                        }
                        partialWriter.endError();
                        partialWriter.endDocument();
                    }
                    catch (IOException ioe) {
                        throw new FacesException("Could not write the error page", (Throwable)ioe);
                    }
                }
                httpResp.setContentType("text/html; charset=UTF-8");
                try {
                    PrintWriter writer = httpResp.getWriter();
                    ErrorPageWriter.debugHtml(writer, facesContext, ex);
                }
                catch (IOException ioe) {
                    throw new FacesException("Could not write the error page", (Throwable)ioe);
                }
                log.log(Level.SEVERE, "An exception occurred", ex);
                facesContext.responseComplete();
                errorPageWritten = true;
            }
        }
        if (!errorPageWritten) {
            if (ex instanceof FacesException) {
                throw (FacesException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new FacesException(ex);
        }
    }

    private static String _getErrorTemplate(FacesContext context) {
        String errorTemplate = context.getExternalContext().getInitParameter(ERROR_TEMPLATE_RESOURCE);
        if (errorTemplate != null) {
            return errorTemplate;
        }
        return ERROR_TEMPLATE;
    }

    private static String _getDebugTemplate(FacesContext context) {
        String debugTemplate = context.getExternalContext().getInitParameter(DEBUG_TEMPLATE_RESOURCE);
        if (debugTemplate != null) {
            return debugTemplate;
        }
        return DEBUG_TEMPLATE;
    }

    private static void _init(FacesContext context) throws IOException {
        if (errorParts == null) {
            errorParts = ErrorPageWriter._splitTemplate(ErrorPageWriter._getErrorTemplate(context));
        }
        if (debugParts == null) {
            debugParts = ErrorPageWriter._splitTemplate(ErrorPageWriter._getDebugTemplate(context));
        }
    }

    private static String[] _splitTemplate(String rsc) throws IOException {
        int read;
        InputStream is = ClassUtils.getContextClassLoader().getResourceAsStream(rsc);
        if (is == null && (is = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(rsc)) == null) {
            is = ErrorPageWriter.class.getClassLoader().getResourceAsStream(rsc);
        }
        if (is == null) {
            throw new IllegalArgumentException("Could not find resource " + rsc);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        String str = baos.toString();
        return str.split("@@");
    }

    private static List<String> _getErrorId(Collection<UIComponent> components, Throwable ... exs) {
        ArrayList<String> list = null;
        for (Throwable e : exs) {
            String message = e.getMessage();
            if (message == null) continue;
            Pattern pattern = Pattern.compile(REGEX_PATTERN);
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(matcher.group(1));
            }
        }
        if (list != null && list.size() > 0) {
            return list;
        }
        if (components != null) {
            list = new ArrayList<String>();
            for (UIComponent uiComponent : components) {
                if (uiComponent == null) continue;
                list.add(uiComponent.getId());
            }
            return list;
        }
        return null;
    }

    private static void _writeException(Writer writer, Throwable e) throws IOException {
        StringWriter str = new StringWriter(256);
        PrintWriter pstr = new PrintWriter(str);
        e.printStackTrace(pstr);
        pstr.close();
        writer.write(str.toString().replaceAll("<", TS));
    }

    private static void _writeCause(Writer writer, Throwable ex) throws IOException {
        ContextAware caex;
        String msg = ex.getMessage();
        String contextAwareLocation = null;
        if (ex instanceof ContextAware) {
            caex = (ContextAware)((Object)ex);
            contextAwareLocation = caex.getLocation().toString() + "    " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
        }
        while (ex.getCause() != null) {
            if ((ex = ex.getCause()) instanceof ContextAware) {
                caex = (ContextAware)((Object)ex);
                contextAwareLocation = caex.getLocation().toString() + "    " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
            }
            if (ex.getMessage() == null) continue;
            msg = ex.getMessage();
        }
        if (msg != null) {
            msg = ex.getClass().getName() + " - " + msg;
            writer.write(msg.replaceAll("<", TS));
        } else {
            writer.write(ex.getClass().getName());
        }
        StackTraceElement stackTraceElement = ex.getStackTrace()[0];
        writer.write("<br/> at " + stackTraceElement.toString());
        if (contextAwareLocation != null) {
            writer.write("<br/> <br/>");
            writer.write(contextAwareLocation);
            writer.write("<br/>");
        }
    }

    private static void _writeVariables(Writer writer, FacesContext faces, UIViewRoot view) throws IOException {
        MyfacesConfig config;
        ExternalContext ctx = faces.getExternalContext();
        ErrorPageWriter._writeVariables(writer, ctx.getRequestParameterMap(), "Request Parameters");
        ErrorPageWriter._writeVariables(writer, ctx.getRequestMap(), "Request Attributes");
        if (view != null) {
            ErrorPageWriter._writeVariables(writer, view.getViewMap(), "View Attributes");
        }
        if (ctx.getSession(false) != null) {
            ErrorPageWriter._writeVariables(writer, ctx.getSessionMap(), "Session Attributes");
        }
        if ((config = MyfacesConfig.getCurrentInstance(ctx)) != null && !config.isFlashScopeDisabled() && ctx.getFlash() != null) {
            ErrorPageWriter._writeVariables(writer, (Map<String, ? extends Object>)ctx.getFlash(), "Flash Attributes");
        }
        ErrorPageWriter._writeVariables(writer, ctx.getApplicationMap(), "Application Attributes");
    }

    private static void _writeVariables(Writer writer, Map<String, ? extends Object> vars, String caption) throws IOException {
        writer.write("<table><caption>");
        writer.write(caption);
        writer.write("</caption><thead><tr><th style=\"width: 10%; \">Name</th><th style=\"width: 90%; \">Value</th></tr></thead><tbody>");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap<String, ? extends Object> sortedMap = new TreeMap<String, Object>(vars);
            for (Map.Entry entry : sortedMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.indexOf(46) != -1) continue;
                writer.write("<tr><td>");
                writer.write(key.replaceAll("<", TS));
                writer.write("</td><td>");
                Object value = entry.getValue();
                if (value != null && value.toString() != null) {
                    writer.write(value.toString().replaceAll("<", TS));
                } else {
                    writer.write("null");
                }
                writer.write("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            writer.write("<tr><td colspan=\"2\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void _writeComponent(FacesContext faces, Writer writer, UIComponent c, List<String> highlightId, boolean writeChildren) throws IOException {
        int stateSize;
        boolean hasChildren;
        block10: {
            String id;
            writer.write("<dl><dt");
            if (ErrorPageWriter._isText(c)) {
                writer.write(" class=\"uicText\"");
            }
            if (highlightId != null && highlightId.size() > 0 && highlightId.contains(id = c.getId())) {
                writer.write(" class=\"highlightComponent\"");
            }
            writer.write(">");
            hasChildren = (c.getChildCount() > 0 || c.getFacetCount() > 0) && writeChildren;
            stateSize = 0;
            Object state = c.saveState(faces);
            if (state != null) {
                try {
                    byte[] stateBytes = StateUtils.getAsByteArray(state, faces.getExternalContext());
                    stateSize = stateBytes.length;
                }
                catch (Exception e) {
                    stateSize = -1;
                    if (!log.isLoggable(Level.FINEST)) break block10;
                    log.fine("Could not determine state size: " + e.getMessage());
                }
            }
        }
        ErrorPageWriter._writeStart(writer, c, hasChildren, true);
        writer.write(" - State size:" + stateSize + " bytes");
        writer.write("</dt>");
        if (hasChildren) {
            if (c.getFacetCount() > 0) {
                for (Map.Entry entry : c.getFacets().entrySet()) {
                    writer.write("<dd class=\"uicFacet\">");
                    writer.write("<span>");
                    writer.write((String)entry.getKey());
                    writer.write("</span>");
                    ErrorPageWriter._writeComponent(faces, writer, (UIComponent)entry.getValue(), highlightId, true);
                    writer.write("</dd>");
                }
            }
            if (c.getChildCount() > 0) {
                int childCount = c.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)c.getChildren().get(i);
                    writer.write("<dd>");
                    ErrorPageWriter._writeComponent(faces, writer, child, highlightId, writeChildren);
                    writer.write("</dd>");
                }
            }
            writer.write("<dt>");
            ErrorPageWriter._writeEnd(writer, c);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void _writeExtendedComponentTree(Writer writer, FacesContext facesContext) throws IOException {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, EnumSet.of(VisitHint.SKIP_UNRENDERED));
        facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new ExtendedComponentTreeVisitCallback(writer));
        ErrorPageWriter._clearVisitedFacetCountMap(facesContext);
    }

    private static boolean _isFirstUIColumn(UIComponent uidata, UIColumn uicolumn) {
        int childCount = uidata.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)uidata.getChildren().get(i);
            if (!(child instanceof UIColumn)) continue;
            return child == uicolumn;
        }
        return false;
    }

    private static String _getFacetName(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent != null && parent.getFacetCount() > 0) {
            for (Map.Entry entry : parent.getFacets().entrySet()) {
                if (entry.getValue() != component) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    private static int _getVisitedFacetCount(FacesContext facesContext, UIComponent component) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount == null) {
            return 0;
        }
        Integer count = (Integer)visitedFacetCount.get(component);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private static void _incrementVisitedFacetCount(FacesContext facesContext, UIComponent component) {
        HashMap<UIComponent, Integer> visitedFacetCount = (HashMap<UIComponent, Integer>)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount == null) {
            visitedFacetCount = new HashMap<UIComponent, Integer>();
            facesContext.getAttributes().put(VISITED_FACET_COUNT_KEY, visitedFacetCount);
        }
        visitedFacetCount.put(component, ErrorPageWriter._getVisitedFacetCount(facesContext, component) + 1);
    }

    private static void _removeVisitedFacetCount(FacesContext facesContext, UIComponent component) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount == null) {
            return;
        }
        visitedFacetCount.remove(component);
    }

    private static void _clearVisitedFacetCountMap(FacesContext facesContext) {
        Map visitedFacetCount = (Map)facesContext.getAttributes().get(VISITED_FACET_COUNT_KEY);
        if (visitedFacetCount != null) {
            visitedFacetCount.clear();
            facesContext.getAttributes().remove(VISITED_FACET_COUNT_KEY);
        }
    }

    private static void _writeEnd(Writer writer, UIComponent c) throws IOException {
        if (!ErrorPageWriter._isText(c)) {
            writer.write(TS);
            writer.write(47);
            writer.write(ErrorPageWriter._getName(c));
            writer.write(62);
        }
    }

    private static void _writeAttributes(Writer writer, UIComponent c, boolean valueExpressionValues) {
        try {
            String location;
            BeanInfo info = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            Method m = null;
            Object v = null;
            ValueExpression valueExpression = null;
            String str = null;
            for (int i = 0; i < pd.length; ++i) {
                if (pd[i].getWriteMethod() == null && Arrays.binarySearch(ALWAYS_WRITE, pd[i].getName()) <= -1 || Arrays.binarySearch(IGNORE, pd[i].getName()) >= 0 || (m = pd[i].getReadMethod()) == null) continue;
                try {
                    valueExpression = c.getValueExpression(pd[i].getName());
                    if (valueExpressionValues && valueExpression != null) {
                        String expressionString = valueExpression.getExpressionString();
                        if (null == expressionString) {
                            expressionString = "";
                        }
                        ErrorPageWriter._writeAttribute(writer, pd[i].getName(), expressionString);
                        continue;
                    }
                    v = m.invoke((Object)c, null);
                    if (v == null || v instanceof Collection || v instanceof Map || v instanceof Iterator) continue;
                    str = v instanceof Expression ? ((Expression)v).getExpressionString() : (v instanceof ValueBinding ? ((ValueBinding)v).getExpressionString() : (v instanceof MethodBinding ? ((MethodBinding)v).getExpressionString() : v.toString()));
                    ErrorPageWriter._writeAttribute(writer, pd[i].getName(), str);
                    continue;
                }
                catch (Exception expressionString) {
                    // empty catch block
                }
            }
            ValueExpression binding = c.getValueExpression("binding");
            if (binding != null) {
                ErrorPageWriter._writeAttribute(writer, "binding", binding.getExpressionString());
            }
            if ((location = ErrorPageWriter._getComponentLocation(c)) != null) {
                ErrorPageWriter._writeAttribute(writer, "location", location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void _writeAttribute(Writer writer, String name, String value) throws IOException {
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(value.replaceAll("<", TS));
        writer.write("\"");
    }

    private static void _writeStart(Writer writer, UIComponent c, boolean children, boolean valueExpressionValues) throws IOException {
        if (ErrorPageWriter._isText(c)) {
            String str = c.toString().trim();
            writer.write(str.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(ErrorPageWriter._getName(c));
            ErrorPageWriter._writeAttributes(writer, c, valueExpressionValues);
            if (children) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String _getName(UIComponent c) {
        String nm = c.getClass().getName();
        return nm.substring(nm.lastIndexOf(46) + 1);
    }

    private static boolean _isText(UIComponent c) {
        return c.getClass().getName().startsWith("org.apache.myfaces.view.facelets.compiler");
    }

    private static void _prepareExceptionStack(Throwable ex) {
        if (ex == null) {
            return;
        }
        if (!ErrorPageWriter._initCausePerReflection(ex, "getRootCause")) {
            ErrorPageWriter._initCausePerReflection(ex, "getCause");
        }
        ErrorPageWriter._prepareExceptionStack(ex.getCause());
    }

    private static boolean _initCausePerReflection(Throwable ex, String methodName) {
        try {
            Method causeGetter = ex.getClass().getMethod(methodName, null);
            Throwable rootCause = (Throwable)causeGetter.invoke((Object)ex, (Object[])null);
            return ErrorPageWriter._initCauseIfAvailable(ex, rootCause);
        }
        catch (Exception e1) {
            return false;
        }
    }

    private static boolean _initCauseIfAvailable(Throwable th, Throwable cause) {
        if (cause == null) {
            return false;
        }
        try {
            Method m = Throwable.class.getMethod("initCause", Throwable.class);
            m.invoke((Object)th, cause);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String _getComponentLocation(UIComponent component) {
        Location location = (Location)component.getAttributes().get("javax.faces.component.VIEW_LOCATION_KEY");
        if (location != null) {
            return location.toString();
        }
        return null;
    }

    static {
        IGNORE = new String[]{"parent", "rendererType"};
        ALWAYS_WRITE = new String[]{"class", "clientId"};
    }

    private static class ExtendedComponentTreeVisitCallback
    implements VisitCallback {
        private Writer _writer;

        public ExtendedComponentTreeVisitCallback(Writer writer) {
            this._writer = writer;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            block23: {
                Map requestMap = context.getFacesContext().getExternalContext().getRequestMap();
                try {
                    if (!(target instanceof UIViewRoot)) {
                        this._writer.write("<dd>");
                    }
                    UIComponent parent = target.getParent();
                    boolean hasChildren = target.getChildCount() > 0 || target.getFacetCount() > 0;
                    String facetName = ErrorPageWriter._getFacetName(target);
                    if (!(target instanceof UIColumn)) {
                        if (parent instanceof UIColumn && (parent.getChildCount() > 0 && parent.getChildren().get(0) == target || facetName != null && ErrorPageWriter._getVisitedFacetCount(context.getFacesContext(), parent) == 0)) {
                            if (parent.getParent() instanceof UIData && ErrorPageWriter._isFirstUIColumn(parent.getParent(), (UIColumn)parent)) {
                                this._writer.write("<span>Row: ");
                                int rowIndex = ((UIData)parent.getParent()).getRowIndex();
                                this._writer.write("" + rowIndex);
                                if (rowIndex == -1) {
                                    this._writer.write(" (all column facets)");
                                }
                                this._writer.write("</span>");
                            }
                            this._writer.write("<dl><dt>");
                            ErrorPageWriter._writeStart(this._writer, parent, true, false);
                            this._writer.write("</dt><dd>");
                        }
                        if (facetName != null) {
                            this._writer.write("<span>" + facetName + "</span>");
                            ErrorPageWriter._incrementVisitedFacetCount(context.getFacesContext(), parent);
                        }
                        this._writer.write("<dl><dt");
                        if (ErrorPageWriter._isText(target)) {
                            this._writer.write(" class=\"uicText\"");
                        }
                        this._writer.write(">");
                        Map debugInfos = null;
                        if (target instanceof EditableValueHolder) {
                            debugInfos = (Map)requestMap.get(ErrorPageWriter.DEBUG_INFO_KEY + target.getClientId());
                        }
                        Renderer renderer = null;
                        try {
                            Method getRenderer = UIComponent.class.getDeclaredMethod("getRenderer", FacesContext.class);
                            getRenderer.setAccessible(true);
                            renderer = (Renderer)getRenderer.invoke((Object)target, context.getFacesContext());
                        }
                        catch (Exception getRenderer) {
                            // empty catch block
                        }
                        ErrorPageWriter._writeStart(this._writer, target, hasChildren || debugInfos != null || renderer != null, false);
                        this._writer.write("</dt>");
                        if (renderer != null) {
                            this._writer.write("<div class=\"renderer\">Rendered by ");
                            this._writer.write(renderer.getClass().getCanonicalName());
                            this._writer.write("</div>");
                            if (!hasChildren && debugInfos == null) {
                                this._writer.write("<dt>");
                                ErrorPageWriter._writeEnd(this._writer, target);
                                this._writer.write("</dt>");
                            }
                        }
                        if (debugInfos != null) {
                            String fieldid = target.getClientId() + "_lifecycle";
                            this._writer.write("<div class=\"lifecycle_values_wrapper\">");
                            this._writer.write("<a href=\"#\" onclick=\"toggle('");
                            this._writer.write(fieldid);
                            this._writer.write("'); return false;\"><span id=\"");
                            this._writer.write(fieldid);
                            this._writer.write("Off\">+</span><span id=\"");
                            this._writer.write(fieldid);
                            this._writer.write("On\" style=\"display: none;\">-</span> Value Lifecycle</a>");
                            this._writer.write("<div id=\"");
                            this._writer.write(fieldid);
                            this._writer.write("\" class=\"lifecycle_values\">");
                            for (Map.Entry entry : debugInfos.entrySet()) {
                                this._writer.write("<span>");
                                this._writer.write((String)entry.getKey());
                                this._writer.write("</span><ol>");
                                int i = 0;
                                for (Object[] debugInfo : (List)entry.getValue()) {
                                    String oldValue = debugInfo[1] == null ? "null" : debugInfo[1].toString();
                                    String newValue = debugInfo[2] == null ? "null" : debugInfo[2].toString();
                                    this._writer.write("<li><b>");
                                    this._writer.write((String)entry.getKey());
                                    this._writer.write("</b> set from <b>");
                                    this._writer.write(oldValue);
                                    this._writer.write("</b> to <b>");
                                    this._writer.write(newValue);
                                    this._writer.write("</b> in Phase ");
                                    this._writer.write(debugInfo[0].toString());
                                    if (debugInfo[3] != null) {
                                        String stackTraceId = fieldid + "_" + (String)entry.getKey() + "_" + i;
                                        this._writer.write("<div class=\"stacktrace_wrapper\">");
                                        this._writer.write("<a href=\"#\" onclick=\"toggle('");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("'); return false;\"><span id=\"");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("Off\">+</span><span id=\"");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("On\" style=\"display: none;\">-</span> Call Stack</a>");
                                        this._writer.write("<div id=\"");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("\" class=\"stacktrace_values\">");
                                        this._writer.write("<ul>");
                                        for (StackTraceElement stackTraceElement : (List)debugInfo[3]) {
                                            this._writer.write("<li>");
                                            this._writer.write(stackTraceElement.toString());
                                            this._writer.write("</li>");
                                        }
                                        this._writer.write("</ul></div></div>");
                                    }
                                    this._writer.write("</li>");
                                    ++i;
                                }
                                this._writer.write("</ol>");
                            }
                            this._writer.write("</div></div>");
                            requestMap.remove(ErrorPageWriter.DEBUG_INFO_KEY + target.getClientId());
                            if (!hasChildren) {
                                this._writer.write("<dt>");
                                ErrorPageWriter._writeEnd(this._writer, target);
                                this._writer.write("</dt>");
                            }
                        }
                    }
                    if (hasChildren) break block23;
                    this._writer.write("</dl>");
                    while (parent != null && (parent.getChildCount() > 0 && parent.getChildren().get(parent.getChildCount() - 1) == target || parent.getFacetCount() != 0 && ErrorPageWriter._getVisitedFacetCount(context.getFacesContext(), parent) == parent.getFacetCount())) {
                        UIRepeat uirepeat;
                        UIData uidata;
                        ErrorPageWriter._removeVisitedFacetCount(context.getFacesContext(), parent);
                        if (!(parent instanceof UIData ? (uidata = (UIData)parent).getRowIndex() != uidata.getRowCount() - 1 : parent instanceof UIRepeat && (uirepeat = (UIRepeat)parent).getIndex() + uirepeat.getStep() < uirepeat.getRowCount())) {
                            this._writer.write("</dd><dt>");
                            ErrorPageWriter._writeEnd(this._writer, parent);
                            this._writer.write("</dt></dl>");
                            if (!(parent instanceof UIViewRoot)) {
                                this._writer.write("</dd>");
                            }
                            target = parent;
                            parent = target.getParent();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    throw new FacesException((Throwable)ioe);
                }
            }
            return VisitResult.ACCEPT;
        }
    }

    public static class ErrorPageBean
    implements Serializable {
        private static final long serialVersionUID = -79513324193326616L;

        public String getErrorPageHtml() throws IOException {
            String head;
            String body;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            Throwable t = (Throwable)requestMap.get(ErrorPageWriter.EXCEPTION_KEY);
            if (t == null) {
                throw new IllegalStateException("No Exception to handle");
            }
            UIViewRoot view = (UIViewRoot)requestMap.get(ErrorPageWriter.VIEW_KEY);
            StringWriter writer = new StringWriter();
            ErrorPageWriter.debugHtml(writer, facesContext, view, null, new Throwable[]{t});
            String html = writer.toString();
            try {
                body = html.substring(html.indexOf("<body>") + "<body>".length(), html.indexOf("</body>"));
            }
            catch (Exception e) {
                return html;
            }
            try {
                head = html.substring(html.indexOf("<head>") + "<head>".length(), html.indexOf("</head>"));
            }
            catch (Exception e) {
                return body;
            }
            StringBuilder builder = new StringBuilder(body);
            int startIndex = 0;
            try {
                while (true) {
                    int endIndex = head.indexOf("</style>", startIndex) + "</style>".length();
                    builder.append(head.substring(head.indexOf("<style", startIndex), endIndex));
                    startIndex = endIndex;
                }
            }
            catch (Exception e) {
                startIndex = 0;
                try {
                    while (true) {
                        int endIndex = head.indexOf("</script>", startIndex) + "</script>".length();
                        builder.append(head.substring(head.indexOf("<script", startIndex), endIndex));
                        startIndex = endIndex;
                    }
                }
                catch (Exception e2) {
                    return builder.toString();
                }
            }
        }
    }
}

