/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.FlowScoped;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.util.AbstractContextualStorageHolder;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.flow.FlowUtils;
import org.apache.myfaces.util.lang.LRULinkedHashMap;

@Typed(value={FlowScopeContextualStorageHolder.class})
@SessionScoped
public class FlowScopeContextualStorageHolder
extends AbstractContextualStorageHolder<ContextualStorage>
implements Serializable {
    @Inject
    @Initialized(value=FlowScoped.class)
    private Event<Flow> flowInitializedEvent;
    @Inject
    @BeforeDestroyed(value=FlowScoped.class)
    private Event<Flow> flowBeforeDestroyedEvent;
    @Inject
    @Destroyed(value=FlowScoped.class)
    private Event<Flow> flowDestroyedEvent;
    private Map<String, List<String>> activeFlowMapKeys;
    private LRULinkedHashMap<String, String> clientWindowExpirationStack;
    public static final String CURRENT_FLOW_SCOPE_MAP = "oam.CURRENT_FLOW_SCOPE_MAP";

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.activeFlowMapKeys = new ConcurrentHashMap<String, List<String>>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Integer numberOfClientWindowsInSession = MyfacesConfig.getCurrentInstance(facesContext).getNumberOfClientWindows();
        this.clientWindowExpirationStack = new LRULinkedHashMap((int)numberOfClientWindowsInSession, eldest -> this.clearFlowMap(FacesContext.getCurrentInstance(), (String)eldest.getKey()));
        this.refreshClientWindow(facesContext);
    }

    public Map<Object, Object> getFlowScopeMap(BeanManager beanManager, String flowClientWindowId, boolean create) {
        Object contextualStorage = this.getContextualStorage(flowClientWindowId, create);
        if (contextualStorage == null) {
            return null;
        }
        ContextualInstanceInfo<Object> info = ((ContextualStorage)contextualStorage).getStorage().get(CURRENT_FLOW_SCOPE_MAP);
        if (info == null && create) {
            info = new ContextualInstanceInfo();
            ((ContextualStorage)contextualStorage).getStorage().put(CURRENT_FLOW_SCOPE_MAP, info);
        }
        if (info == null) {
            return null;
        }
        HashMap map = (HashMap)info.getContextualInstance();
        if (map == null && create) {
            map = new HashMap();
            info.setContextualInstance(map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshClientWindow(FacesContext facesContext) {
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        if (cw != null && cw.getId() != null) {
            LRULinkedHashMap<String, String> lRULinkedHashMap = this.clientWindowExpirationStack;
            synchronized (lRULinkedHashMap) {
                this.clientWindowExpirationStack.remove(cw.getId());
                this.clientWindowExpirationStack.put(cw.getId(), "");
            }
        }
    }

    public void clearFlowMap(FacesContext facesContext, String clientWindowId) {
        List<String> activeFlowKeys = this.activeFlowMapKeys.remove(clientWindowId);
        if (activeFlowKeys != null && !activeFlowKeys.isEmpty()) {
            for (String flowMapKey : activeFlowKeys) {
                ContextualStorage contextualStorage = (ContextualStorage)this.storageMap.remove(flowMapKey);
                if (contextualStorage == null) continue;
                this.destroyAll(contextualStorage, facesContext);
            }
        }
    }

    public List<String> getActiveFlowMapKeys(FacesContext facesContext) {
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        String baseKey = cw.getId();
        List<String> activeFlowKeys = this.activeFlowMapKeys.get(baseKey);
        if (activeFlowKeys == null) {
            return Collections.emptyList();
        }
        return activeFlowKeys;
    }

    public void createCurrentFlowScope(FacesContext facesContext) {
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        String baseKey = cw.getId();
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        String flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        List activeFlowKeys = this.activeFlowMapKeys.computeIfAbsent(baseKey, k -> new ArrayList());
        activeFlowKeys.add(0, flowMapKey);
        this.activeFlowMapKeys.put(baseKey, activeFlowKeys);
        this.refreshClientWindow(facesContext);
        this.flowInitializedEvent.fire((Object)flow);
    }

    public void destroyCurrentFlowScope(FacesContext facesContext) {
        List<String> activeFlowKeys;
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        String baseKey = cw.getId();
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        String flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        ContextualStorage contextualStorage = (ContextualStorage)this.storageMap.remove(flowMapKey);
        if (contextualStorage != null) {
            this.destroyAll(contextualStorage, facesContext);
        }
        if ((activeFlowKeys = this.activeFlowMapKeys.get(baseKey)) != null && !activeFlowKeys.isEmpty()) {
            activeFlowKeys.remove(flowMapKey);
        }
        this.flowBeforeDestroyedEvent.fire((Object)flow);
        this.flowDestroyedEvent.fire((Object)flow);
    }

    @Override
    protected boolean isSkipDestroy(Map.Entry<Object, ContextualInstanceInfo<?>> entry) {
        return CURRENT_FLOW_SCOPE_MAP.equals(entry.getKey());
    }

    @Override
    protected ContextualStorage newContextualStorage(String slotId) {
        return new ContextualStorage(this.beanManager, true, this.isPassivating());
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    public static FlowScopeContextualStorageHolder getInstance(FacesContext facesContext) {
        return FlowScopeContextualStorageHolder.getInstance(facesContext, false);
    }

    public static FlowScopeContextualStorageHolder getInstance(FacesContext facesContext, boolean create) {
        return FlowScopeContextualStorageHolder.getInstance(facesContext, FlowScopeContextualStorageHolder.class, create);
    }
}

