/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util;

public class URLUtils {
    public static String appendURLArguments(StringBuilder buffer, String baseURL, String[] keysAndValues) {
        int anchorIndex = baseURL.indexOf(35);
        if (anchorIndex >= 0) {
            buffer.append(baseURL.substring(0, anchorIndex));
        } else {
            buffer.append(baseURL);
        }
        boolean queryAppended = baseURL.indexOf(63) >= 0;
        for (int i = 0; i < keysAndValues.length; i += 2) {
            String value = keysAndValues[i + 1];
            if (value == null) continue;
            if (!queryAppended) {
                queryAppended = true;
                buffer.append('?');
            } else {
                buffer.append('&');
            }
            buffer.append(keysAndValues[i]);
            buffer.append('=');
            buffer.append(value);
        }
        String beforeEncode = buffer.toString();
        return beforeEncode;
    }

    public static String appendURLArguments(String baseURL, String[] keysAndValues) {
        int bufferLength = baseURL.length() + keysAndValues.length;
        for (int i = 0; i < keysAndValues.length; i += 2) {
            String value = keysAndValues[i + 1];
            if (value == null) continue;
            bufferLength += keysAndValues[i].length() + value.length();
        }
        StringBuilder buffer = new StringBuilder(bufferLength);
        return URLUtils.appendURLArguments(buffer, baseURL, keysAndValues);
    }

    public static String convertFromRelative(String currentPath, String relativeLoc) throws IllegalArgumentException {
        int levels = 0;
        int i = 0;
        int length = relativeLoc.length();
        while (i + 1 < length && relativeLoc.charAt(i) == '.') {
            if (relativeLoc.charAt(i) == '.' && relativeLoc.charAt(i + 1) == '/') {
                i += 2;
                continue;
            }
            if (i + 2 >= length || relativeLoc.charAt(i) != '.' || relativeLoc.charAt(i + 1) != '.' || relativeLoc.charAt(i + 2) != '/') continue;
            ++levels;
            i += 3;
        }
        StringBuilder sb = new StringBuilder(currentPath);
        if (currentPath.endsWith("/")) {
            sb = sb.deleteCharAt(currentPath.length() - 1);
        }
        for (int j = 0; j < levels; ++j) {
            int loc = sb.lastIndexOf("/");
            if (loc < 0) {
                throw new IllegalArgumentException("Location: " + relativeLoc + "Can't be made relative to: " + currentPath);
            }
            sb = sb.delete(loc, sb.length());
        }
        sb = sb.append("/");
        sb = sb.append(relativeLoc.substring(i));
        return sb.toString();
    }
}

