/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.convert.GenericConverter;

class BaseConverter
extends GenericConverter {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BaseConverter.class);

    @Override
    public Object convert(Object source, Class<?> targetType) {
        if (source instanceof Calendar) {
            Calendar cal = (Calendar)source;
            return cal.getTime();
        }
        if (source instanceof Date) {
            Date date = (Date)source;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        Number num = (Number)source;
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return num.intValue();
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return num.byteValue();
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return num.doubleValue();
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(num.floatValue());
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return num.longValue();
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return num.shortValue();
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(num.doubleValue());
        }
        throw new IllegalArgumentException(_LOG.getMessage("UNSUPPORTED_CONVERSION", new Object[]{source.getClass(), targetType}));
    }

    @Override
    public List<Class<?>> getTargetTypes(Class<?> sourceType) {
        ArrayList list = new ArrayList(1);
        if (Date.class.isAssignableFrom(sourceType)) {
            list.add(Calendar.class);
        } else if (Calendar.class.isAssignableFrom(sourceType)) {
            list.add(Date.class);
        } else if (Number.class.isAssignableFrom(sourceType)) {
            list.ensureCapacity(13);
            list.add(Byte.class);
            list.add(Double.class);
            list.add(Float.class);
            list.add(Integer.class);
            list.add(Long.class);
            list.add(Short.class);
            list.add(BigDecimal.class);
            list.add(Byte.TYPE);
            list.add(Double.TYPE);
            list.add(Float.TYPE);
            list.add(Integer.TYPE);
            list.add(Long.TYPE);
            list.add(Short.TYPE);
        }
        return list;
    }
}

