/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class TableSelectManyRenderer
extends TableSelectOneRenderer {
    public static final String UNSELECTED_KEY = "_us";
    public static final String SELECTED_KEY = "_s";
    public static final String SELECTED_MODE_KEY = "_sm";
    private static final Object _JS_RENDERED_KEY = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TableSelectManyRenderer.class);

    public TableSelectManyRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        UIXCollection table = (UIXCollection)component;
        Object oldKey = table.getRowKey();
        table.setRowIndex(-1);
        String tableId = clientId == null ? table.getClientId(facesContext) : clientId;
        Map parameters = facesContext.getExternalContext().getRequestParameterValuesMap();
        String[] unselectedBoxes = (String[])parameters.get(tableId + ':' + UNSELECTED_KEY);
        if (unselectedBoxes == null || unselectedBoxes.length == 0) {
            return;
        }
        String[] selectedBoxes = (String[])parameters.get(tableId + ':' + SELECTED_KEY);
        RowKeySet selectionModel = table instanceof UIXTable ? ((UIXTable)table).getSelectedRowKeys() : ((UIXTree)table).getSelectedRowKeys();
        RowKeySet selectedDelta = selectionModel.clone();
        selectedDelta.clear();
        RowKeySet unselectedDelta = selectedDelta.clone();
        this._setDeltas(table, selectedBoxes, unselectedBoxes, selectionModel, selectedDelta, unselectedDelta);
        if (selectedDelta.getSize() != 0 || unselectedDelta.getSize() != 0) {
            SelectionEvent event = new SelectionEvent((UIComponent)table, unselectedDelta, selectedDelta);
            event.queue();
        }
        table.setRowKey(oldKey);
    }

    private void _setDeltas(UIXCollection table, String[] selectedBoxes, String[] unselectedBoxes, RowKeySet current, RowKeySet selectedDelta, RowKeySet unselectedDelta) {
        String currencyStr;
        int i;
        HashMap<String, Boolean> deltas = new HashMap<String, Boolean>(unselectedBoxes.length);
        for (i = 0; i < unselectedBoxes.length; ++i) {
            currencyStr = unselectedBoxes[i];
            deltas.put(currencyStr, Boolean.FALSE);
        }
        if (selectedBoxes != null) {
            for (i = 0; i < selectedBoxes.length; ++i) {
                currencyStr = selectedBoxes[i];
                deltas.put(currencyStr, Boolean.TRUE);
            }
        }
        for (Map.Entry entry : deltas.entrySet()) {
            String currencyStr2 = (String)entry.getKey();
            boolean select = Boolean.TRUE == entry.getValue();
            table.setClientRowKey(currencyStr2);
            if (select) {
                if (!current.add()) continue;
                selectedDelta.add();
                continue;
            }
            if (!current.remove()) continue;
            unselectedDelta.add();
        }
    }

    @Override
    protected CoreRenderer createCellRenderer(FacesBean.Type type) {
        return new Checkbox(type);
    }

    @Override
    protected boolean isSelectOne() {
        return false;
    }

    public static void renderScripts(FacesContext context, RenderingContext rc, TableRenderingContext trc, boolean autoSubmit) throws IOException {
        if (rc.getProperties().put(_JS_RENDERED_KEY, Boolean.TRUE) == null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            TableSelectManyRenderer.renderScriptDeferAttribute(context, rc);
            TableSelectManyRenderer.renderScriptTypeAttribute(context, rc);
            String jsCall = TreeUtils.setupJSMultiSelectCollectionComponent(SELECTED_KEY, SELECTED_MODE_KEY, autoSubmit);
            writer.writeText((Object)jsCall, null);
            writer.writeText((Object)";", null);
            writer.endElement("script");
        }
        String selectedModeName = trc.getTableId() + ":" + SELECTED_MODE_KEY;
        if (rc.getFormData() != null) {
            rc.getFormData().addNeededValue(selectedModeName);
        }
    }

    @Override
    protected void renderCellContent(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, FacesBean bean) throws IOException {
        super.renderCellContent(context, rc, tContext, component, bean);
        this._renderUnsuccessfulField(context, tContext);
    }

    private void _renderUnsuccessfulField(FacesContext context, TableRenderingContext tContext) throws IOException {
        String unsuccessfulId = tContext.getTableId() + ':' + UNSELECTED_KEY;
        String value = ((UIXCollection)tContext.getCollectionComponent()).getClientRowKey();
        OutputUtils.renderHiddenField(context, unsuccessfulId, value);
    }

    private static class Checkbox
    extends TableSelectOneRenderer.Radio {
        public Checkbox(FacesBean.Type type) {
            super(type);
        }

        @Override
        protected void renderId(FacesContext context, UIComponent component) throws IOException {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            String param = tContext.getTableId() + ':' + TableSelectManyRenderer.SELECTED_KEY;
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("name", (Object)param, null);
            if (this.getShortDesc(component, this.getFacesBean(component)) != null) {
                writer.writeAttribute("id", (Object)this.getClientId(context, component), null);
            }
        }

        @Override
        protected Object getType() {
            return "checkbox";
        }

        @Override
        protected String getDefaultShortDescKey() {
            return "af_tableSelectMany.SELECT_COLUMN_HEADER";
        }
    }
}

