/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_date()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func();
    }

    private static class Func
    extends DateFunction
    implements Function {
        private final long lo;
        private final long range;
        private Rnd rnd;

        public Func() {
            this.lo = 0L;
            this.range = 10000000L;
        }

        @Override
        public long getDate(Record rec) {
            return this.lo + this.rnd.nextPositiveLong() % this.range;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_date(").val(this.lo).val(',').val(this.range).val(')');
        }
    }
}

