/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.util.NiFiProperties;

public class NiFiPropertiesDiagnosticTask
implements DiagnosticTask {
    private static final List<String> PROPERTY_NAMES = Arrays.asList("nifi.cluster.protocol.heartbeat.interval", "nifi.cluster.node.connection.timeout", "nifi.cluster.node.read.timeout", "nifi.zookeeper.connect.timeout", "nifi.zookeeper.session.timeout", "nifi.ui.autorefresh.interval", "nifi.cluster.node.protocol.max.threads", "nifi.security.allow.anonymous.authentication", "nifi.security.user.login.identity.provider", "nifi.security.user.authorizer", "nifi.provenance.repository.implementation", "nifi.provenance.repository.index.shard.size", "nifi.provenance.repository.max.storage.size", "nifi.components.status.repository.buffer.size", "nifi.components.status.snapshot.frequency", "nifi.content.repository.archive.max.retention.period", "nifi.content.repository.archive.max.usage.percentage", "nifi.flowfile.repository.checkpoint.interval", "nifi.flowfile.repository.always.sync", "nifi.components.status.snapshot.frequency", "nifi.bored.yield.duration", "nifi.queue.swap.threshold", "nifi.security.identity.mapping.pattern.dn", "nifi.security.identity.mapping.value.dn", "nifi.security.identity.mapping.transform.dn", "nifi.security.identity.mapping.pattern.kerb", "nifi.security.identity.mapping.value.kerb", "nifi.security.identity.mapping.transform.kerb", "nifi.security.group.mapping.pattern.anygroup", "nifi.security.group.mapping.value.anygroup", "nifi.security.group.mapping.transform.anygroup");
    private final NiFiProperties nifiProperties;

    public NiFiPropertiesDiagnosticTask(NiFiProperties nifiProperties) {
        this.nifiProperties = nifiProperties;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        for (String propertyName : PROPERTY_NAMES) {
            details.add(propertyName + " : " + this.nifiProperties.getProperty(propertyName));
        }
        return new StandardDiagnosticsDumpElement("NiFi Properties", details);
    }
}

