/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToDateFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastDoubleToDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Dm)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToDateFunction {
        private final Function arg;

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            double value = this.arg.getDouble(rec);
            return value == value ? (long)value : Long.MIN_VALUE;
        }
    }
}

