/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.str.CharSink;

class MicroTimestampSampler
implements TimestampSampler {
    private final long bucket;
    private long start;

    MicroTimestampSampler(long bucket) {
        this.bucket = bucket;
    }

    @Override
    public long getBucketSize() {
        return this.bucket;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return timestamp + this.bucket;
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return timestamp - this.bucket;
    }

    @Override
    public long round(long value) {
        return this.start + (value - this.start) / this.bucket * this.bucket;
    }

    @Override
    public void setStart(long timestamp) {
        this.start = timestamp;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("MicroTsSampler");
    }
}

