/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.firewall;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.server.firewall.ServerExchangeRejectedException;
import org.springframework.security.web.server.firewall.ServerExchangeRejectedHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpStatusExchangeRejectedHandler
implements ServerExchangeRejectedHandler {
    private static final Log logger = LogFactory.getLog(HttpStatusExchangeRejectedHandler.class);
    private final HttpStatus status;

    public HttpStatusExchangeRejectedHandler() {
        this(HttpStatus.BAD_REQUEST);
    }

    public HttpStatusExchangeRejectedHandler(HttpStatus status) {
        this.status = status;
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange, ServerExchangeRejectedException serverExchangeRejectedException) {
        return Mono.fromRunnable(() -> {
            logger.debug((Object)LogMessage.format((String)"Rejecting request due to: %s", (Object)serverExchangeRejectedException.getMessage()), (Throwable)serverExchangeRejectedException);
            exchange.getResponse().setStatusCode(this.status);
        });
    }
}

