/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CeilDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "ceil(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CeilFunction(args.getQuick(0));
    }

    private static class CeilFunction
    extends DoubleFunction
    implements UnaryFunction {
        private final Function function;

        public CeilFunction(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public double getDouble(Record rec) {
            double value = this.function.getDouble(rec);
            return Math.ceil(value);
        }

        @Override
        public String getName() {
            return "ceil";
        }
    }
}

