/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.s2s;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.remote.protocol.DataPacket;

public class DataPacketImpl
implements DataPacket {
    private final Map<String, String> attributes;
    private final byte[] data;
    private final String dataFile;

    public DataPacketImpl(Map<String, String> attributes, byte[] data, String dataFile) {
        this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(attributes));
        this.data = data;
        this.dataFile = dataFile;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public InputStream getData() {
        if (this.data == null) {
            if (this.dataFile != null && this.dataFile.length() > 0) {
                try {
                    return new FileInputStream(this.dataFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.data);
    }

    public long getSize() {
        if (this.data == null) {
            if (this.dataFile != null && this.dataFile.length() > 0) {
                return new File(this.dataFile).length();
            }
            return 0L;
        }
        return this.data.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPacketImpl that = (DataPacketImpl)o;
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.attributes != null ? this.attributes.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

