/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex2;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Embeddable;

@Embeddable
public class EmployeePK implements Serializable {
    
    private static final long serialVersionUID = 1L;
    String name;
    Date bDay;

    public EmployeePK() {}
    public EmployeePK(String name, Date bDay) {
        this.name = name;
        this.bDay = bDay;
    }

    public String getName() {
        return name;
    }

    public Date getBDay() {
        return bDay;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof EmployeePK))
            return false;
        EmployeePK pk = (EmployeePK) o;
        if (pk.name.equals(name) &&
            pk.bDay.equals(bDay))
            return true;
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += name.hashCode();
        code += bDay.hashCode();
        return code;
    }
}
